/***************************************************************************
                          ktransactionlistitem.h  -  description
                             -------------------
    begin                : Sun Sep 8 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionlistitem.h,v 1.4 2002/09/10 17:03:07 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSACTIONLISTITEM_H
#define KTRANSACTIONLISTITEM_H

#include <klistview.h>

class Transaction;
class QDate;

/**A transaction list view item
  *@author Richard Garand
  */

class KTransactionListItem : public KListViewItem  {
  public:
    /** default constructor; if t == 0, a blank row is created */
    KTransactionListItem(KListView* parent, Transaction* t = 0, int account = -1);
    KTransactionListItem(KListView* parent, QString description);
    ~KTransactionListItem();

    /** makes this item a total row */
    void setTotals(float debits, float credits);
    /** sets a special sort priority */
    void setSortPriority(int priority);

    /** compare to another KTranasctionListItem */
    int compare(QListViewItem* i, int col, bool asc) const;

    /** return the transaction ID or -1 */
    int tid() const;
  private:
    void okRename(int col);
  
    Transaction* m_transaction;
    float m_debits, m_credits;
    QDate m_date;
    int m_priority;
};

#endif
