/***************************************************************************
                          ktransactionwindow.h  -  description
                             -------------------
    begin                : Sat Sep 7 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionwindow.h,v 1.5 2002/09/10 01:02:50 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSACTIONWINDOW_H
#define KTRANSACTIONWINDOW_H

#include <qwidget.h>
#include <kmainwindow.h>

class KTransactionWidget;
class KAction;
class KBudgetDoc;
class QPopupMenu;

/**Creates a window to display a list of transactions
  *@author Richard Garand
  */

class KTransactionWindow : public KMainWindow  {
  Q_OBJECT
  public: 
    KTransactionWindow(KBudgetDoc* doc, QDate month, int account=-1);
    ~KTransactionWindow();

    static bool closeAllWindows();

  public slots:
    void slotFileClose();
    void slotViewAll();
    void slotViewSelected();
    void slotTransactionEdit();
    void slotToggleToolBar();
    void slotConfKeys();
    void slotConfToolbar();
    void slotContextMenuRequested(const QPoint& p);
    void slotTransactionFuncsEnabled(bool enabled);

  protected:
    static QPtrList<KTransactionWindow> instances;

  private:
    void initGUI();

    KBudgetDoc* m_doc;
    int m_account;
    QDate m_month;
  
    KTransactionWidget* transactionWidget;

    KAction* fileClose;
    KAction* viewAll;
    KAction* viewSelected;
    KAction* transactionEdit;
    KAction* transactionRename;
    KAction* transactionDelete;
    KToggleAction* showToolbar;

    QPopupMenu* mainPopup;
};

#endif
