/***************************************************************************
                               emailthread.h
                              ----------------
    begin                : Jul 7 2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMAILTHREAD_H
#define EMAILTHREAD_H

#include <qthread.h>
#include <qsocketdevice.h>

class EMailThread : public QThread {
  public:
    EMailThread( const QString& strTo,
                 const QString& strFrom,
                 const QString& strSubject,
                 const QString& strBody,
                 const QString& strSMTPServer );
    virtual ~EMailThread();

    virtual void run();

  private:
    enum State {
        Init,
        Mail,
        Rcpt,
        Data,
        Body,
        Quit,
        Close
    };

    bool          write(QSocketDevice& socketDevice, const QString& strWrite);
    void          read(QSocketDevice& socketDevice);
    
    QString       _strFrom;
    QString       _strTo;
    QString       _strBody;
    QString       _strSubject;
    QString       _strSMTPServer;
    QString       _strMessage;
    State         _state;
};


#endif

// vim: ts=2 sw=2 et
