/***************************************************************************
 *   Copyright (C) 2004 by Richard Moore                                   *
 *   rich@kde.org                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef QT_ONLY

#include "global.h"
#include <qobject.h>
#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
#include <fcntl.h>
#include <io.h>
#include <iostream.h>

#endif

static QTextStream *kjsembed_errors = 0L;

#ifdef _WIN32

static const WORD MAX_CONSOLE_LINES = 500;

void RedirectIOToConsole() {
   int hConHandle;
   long lStdHandle;
   CONSOLE_SCREEN_BUFFER_INFO coninfo;
   FILE *fp;
   AllocConsole(); 
   GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &coninfo);
   coninfo.dwSize.Y = MAX_CONSOLE_LINES;
   SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE), coninfo.dwSize);
   
   lStdHandle = (long)GetStdHandle(STD_OUTPUT_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   if( hConHandle != -1 )
   {
      fp = _fdopen( hConHandle, "w" );
      *stdout = *fp;
      setvbuf( stdout, NULL, _IONBF, 0 );
   }

   lStdHandle = (long)GetStdHandle(STD_INPUT_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   if( hConHandle != -1 )
   {
      fp = _fdopen( hConHandle, "r" );
      *stdin = *fp;
      setvbuf( stdin, NULL, _IONBF, 0 );
   }

   lStdHandle = (long)GetStdHandle(STD_ERROR_HANDLE);
   hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
   if( hConHandle != -1 )
   {
      fp = _fdopen( hConHandle, "w" );
      *stderr = *fp;
      setvbuf( stderr, NULL, _IONBF, 0 );
   }
	
   ios::sync_with_stdio();

}



#endif


QTextStream &consoleOut(  )
{
   if ( !kjsembed_errors ) {
#ifdef _WIN32
//      RedirectIOToConsole();
#endif
      kjsembed_errors = new QTextStream( stderr, IO_WriteOnly );
   }
   return *kjsembed_errors;
}

QTextStream &kdDebug( int area )
{
	   return consoleOut() << "DEBUG: (" << area << ") ";
}

QTextStream &kdWarning( int area )
{
   return consoleOut() << "WARNING: (" << area << ") ";
}

QString i18n( const char *string )
{
	return QObject::tr( string, "qjsembed string");
}
#endif // QT_ONLY
