/***************************************************************************
             kstsettings.cpp: a collection of settings for kst
                             -------------------
    begin                : Nov 23, 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstsettings.h"

#include <kconfig.h>
#include <kstaticdeleter.h>

KstSettings::KstSettings() {
  plotUpdateTimer = 200;
  backgroundColor = QColor(255, 255, 255); // white
  foregroundColor = QColor(0,0,0); // black
  promptWindowClose = true;
  showQuickStart = true;

  xMajor = false;
  yMajor = false;
  xMinor = false;
  yMinor = false;
  majorColor = QColor(128,128,128);
  minorColor = QColor(128,128,128);
  majorGridColorDefault = true;
  minorGridColorDefault = true;

  xAxisInterpret = false;
  xAxisInterpretation = X_AXIS_INTERP_CTIME;
  xAxisDisplay = X_AXIS_DISPLAY_QTLOCALDATEHHMMSS_SS;
}


KstSettings::KstSettings(const KstSettings& x) {
  *this = x;
}


KstSettings& KstSettings::operator=(const KstSettings& x) {
  plotUpdateTimer = x.plotUpdateTimer;
  backgroundColor = x.backgroundColor;
  foregroundColor = x.foregroundColor;
  promptWindowClose = x.promptWindowClose;
  showQuickStart = x.showQuickStart;

  xMajor = x.xMajor;
  yMajor = x.yMajor;
  xMinor = x.xMinor;
  yMinor = x.yMinor;
  majorColor = x.majorColor;
  minorColor = x.minorColor;
  majorGridColorDefault = x.majorGridColorDefault;
  minorGridColorDefault = x.minorGridColorDefault;

  xAxisInterpret = x.xAxisInterpret;
  xAxisInterpretation = x.xAxisInterpretation;
  xAxisDisplay = x.xAxisDisplay;

  return *this;
}


KstSettings *KstSettings::_self = 0L;
static KStaticDeleter<KstSettings> kstsettingssd;

KstSettings *KstSettings::globalSettings() {
  if (!_self) {
    _self = kstsettingssd.setObject(_self, new KstSettings);
    _self->reload();
  }

  return _self;
}


void KstSettings::setGlobalSettings(const KstSettings *settings) {
  globalSettings(); // force instantiation

  *_self = *settings;
}


void KstSettings::save() {
  KConfig cfg("kstrc", false, false);

  cfg.setGroup("Kst");
  cfg.writeEntry("Plot Update Timer", plotUpdateTimer);
  cfg.writeEntry("Background Color", backgroundColor);
  cfg.writeEntry("Foreground Color", foregroundColor);
  cfg.writeEntry("Prompt on Window Close", promptWindowClose);
  cfg.writeEntry("Show QuickStart", showQuickStart);

  cfg.writeEntry("X Major Grid Lines", xMajor);
  cfg.writeEntry("Y Major Grid Lines", yMajor);
  cfg.writeEntry("X Minor Grid Lines", xMinor);
  cfg.writeEntry("Y Minor Grid Lines", yMinor);
  cfg.writeEntry("Major Grid Lines Color", majorColor);
  cfg.writeEntry("Minor Grid Lines Color", minorColor);
  cfg.writeEntry("Default Major Grid Lines Color", majorGridColorDefault);
  cfg.writeEntry("Default Minor Grid Lines Color", minorGridColorDefault);

  cfg.writeEntry("X Axis Interpret", xAxisInterpret);
  cfg.writeEntry("X Axis Interpretation", xAxisInterpretation);
  cfg.writeEntry("X Axis Display", xAxisDisplay);

  cfg.sync();
}


void KstSettings::reload() {
  KConfig cfg("kstrc");

  cfg.setGroup("Kst");
  plotUpdateTimer = cfg.readNumEntry("Plot Update Timer", 50);
  backgroundColor = cfg.readColorEntry("Background Color", &backgroundColor);
  foregroundColor = cfg.readColorEntry("Foreground Color", &foregroundColor);
  promptWindowClose = cfg.readBoolEntry("Prompt on Window Close", true);
  showQuickStart = cfg.readBoolEntry("Show QuickStart", true);
  
  xMajor = cfg.readBoolEntry("X Major Grid Lines", false);
  yMajor = cfg.readBoolEntry("Y Major Grid Lines", false);
  xMinor = cfg.readBoolEntry("X Minor Grid Lines", false);
  yMinor = cfg.readBoolEntry("Y Minor Grid Lines", false);
  majorColor = cfg.readColorEntry("Major Grid Lines Color", &majorColor);
  minorColor = cfg.readColorEntry("Minor Grid Lines Color", &minorColor);
  majorGridColorDefault = cfg.readBoolEntry("Default Major Grid Lines Color", true);
  minorGridColorDefault = cfg.readBoolEntry("Default Minor Grid Lines Color", true);

  xAxisInterpret = cfg.readBoolEntry("X Axis Interpret", false);
  xAxisInterpretation = (KstXAxisInterpretation)cfg.readNumEntry("X Axis Interpretation", X_AXIS_INTERP_CTIME);
  xAxisDisplay = (KstXAxisDisplay)cfg.readNumEntry("X Axis Display", X_AXIS_DISPLAY_QTLOCALDATEHHMMSS_SS);
}


// vim: ts=2 sw=2 et
