/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    // error string to display
    property string errorStr;

    // get color from current plasma theme
    property QtObject theme: PlasmaCore.Theme {}

    Text {
        id: errorMsg;
        text: errorStr;
        height: parent.height/2;
        color: theme.textColor;
        horizontalAlignment: Text.AlignHCenter;
        clip: true;
        wrapMode: Text.WordWrap;
        font.bold: true;

        anchors {
            top: parent.top;
            left: parent.left;
            right: parent.right;
            margins: 10;
        }
    }

    PlasmaWidgets.IconWidget {
        id: errorIcon;
        width: 128;
        height: 128;

        Component.onCompleted: {
            setIcon("dialog-error");
        }

        anchors {
            top: errorMsg.bottom;
            left: parent.left;
            right: parent.right;
        }
    }

    ///TODO add a refresh button to send signal to right panel to reload the dataengine on the fly
}
