/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class GeneratePluginDescriptors
extends DefaultTask {
    private final Provider<Map<String, String>> implementationClassById = this.getDeclarations().map(declarations -> declarations.stream().collect(Collectors.toMap(PluginDeclaration::getId, PluginDeclaration::getImplementationClass, (a, b) -> b, LinkedHashMap::new)));

    @Internal(value="Changes for the declarations are tracked via implementationClassById")
    public abstract ListProperty<PluginDeclaration> getDeclarations();

    @Input
    Provider<Map<String, String>> getImplementationClassById() {
        return this.implementationClassById;
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public void generatePluginDescriptors() {
        File outputDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
        this.clearOutputDirectory(outputDir);
        for (Map.Entry entry : ((Map)this.implementationClassById.get()).entrySet()) {
            String id = (String)entry.getKey();
            String implementationClass = (String)entry.getValue();
            File descriptorFile = new File(outputDir, id + ".properties");
            Properties properties = new Properties();
            properties.setProperty("implementation-class", implementationClass);
            this.writePropertiesTo(properties, descriptorFile);
        }
    }

    @Inject
    protected abstract Deleter getDeleter();

    private void clearOutputDirectory(File directoryToClear) {
        try {
            this.getDeleter().ensureEmptyDirectory(directoryToClear);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void writePropertiesTo(Properties properties, File descriptorFile) {
        try {
            PropertiesUtils.store((Properties)properties, (File)descriptorFile);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

