/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.cache.query.QueryCacheStats;
import org.opensearch.index.engine.SegmentsStats;
import org.opensearch.index.fielddata.FieldDataStats;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.store.StoreStats;
import org.opensearch.search.suggest.completion.CompletionStats;

public class ClusterStatsNodeResponse
extends BaseNodeResponse {
    private final NodeInfo nodeInfo;
    private final NodeStats nodeStats;
    private final ShardStats[] shardsStats;
    private ClusterHealthStatus clusterStatus;
    private AggregatedNodeLevelStats aggregatedNodeLevelStats;

    public ClusterStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterStatus = null;
        if (in.readBoolean()) {
            this.clusterStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.nodeInfo = new NodeInfo(in);
        this.nodeStats = new NodeStats(in);
        if (in.getVersion().onOrAfter(Version.V_2_16_0)) {
            this.shardsStats = (ShardStats[])in.readOptionalArray(ShardStats::new, ShardStats[]::new);
            this.aggregatedNodeLevelStats = (AggregatedNodeLevelStats)in.readOptionalWriteable(x$0 -> new AggregatedNodeLevelStats(this, x$0));
        } else {
            this.shardsStats = (ShardStats[])in.readArray(ShardStats::new, ShardStats[]::new);
        }
    }

    public ClusterStatsNodeResponse(DiscoveryNode node, @Nullable ClusterHealthStatus clusterStatus, NodeInfo nodeInfo, NodeStats nodeStats, ShardStats[] shardsStats) {
        super(node);
        this.nodeInfo = nodeInfo;
        this.nodeStats = nodeStats;
        this.shardsStats = shardsStats;
        this.clusterStatus = clusterStatus;
    }

    public ClusterStatsNodeResponse(DiscoveryNode node, @Nullable ClusterHealthStatus clusterStatus, NodeInfo nodeInfo, NodeStats nodeStats, ShardStats[] shardsStats, boolean useAggregatedNodeLevelResponses) {
        super(node);
        this.nodeInfo = nodeInfo;
        this.nodeStats = nodeStats;
        if (useAggregatedNodeLevelResponses) {
            this.aggregatedNodeLevelStats = new AggregatedNodeLevelStats(this, node, shardsStats);
        }
        this.shardsStats = shardsStats;
        this.clusterStatus = clusterStatus;
    }

    public NodeInfo nodeInfo() {
        return this.nodeInfo;
    }

    public NodeStats nodeStats() {
        return this.nodeStats;
    }

    @Nullable
    public ClusterHealthStatus clusterStatus() {
        return this.clusterStatus;
    }

    public ShardStats[] shardsStats() {
        return this.shardsStats;
    }

    public AggregatedNodeLevelStats getAggregatedNodeLevelStats() {
        return this.aggregatedNodeLevelStats;
    }

    public static ClusterStatsNodeResponse readNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.clusterStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.clusterStatus.value());
        }
        this.nodeInfo.writeTo(out);
        this.nodeStats.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_16_0)) {
            if (this.aggregatedNodeLevelStats != null) {
                out.writeOptionalArray(null);
                out.writeOptionalWriteable((Writeable)this.aggregatedNodeLevelStats);
            } else {
                out.writeOptionalArray((Writeable[])this.shardsStats);
                out.writeOptionalWriteable(null);
            }
        } else {
            out.writeArray((Writeable[])this.shardsStats);
        }
    }

    public class AggregatedNodeLevelStats
    extends BaseNodeResponse {
        CommonStats commonStats;
        Map<String, AggregatedIndexStats> indexStatsMap;

        protected AggregatedNodeLevelStats(ClusterStatsNodeResponse this$0, StreamInput in) throws IOException {
            super(in);
            this.commonStats = (CommonStats)in.readOptionalWriteable(CommonStats::new);
            this.indexStatsMap = in.readMap(StreamInput::readString, AggregatedIndexStats::new);
        }

        protected AggregatedNodeLevelStats(ClusterStatsNodeResponse this$0, DiscoveryNode node, ShardStats[] indexShardsStats) {
            super(node);
            this.commonStats = new CommonStats();
            this.commonStats.docs = new DocsStats();
            this.commonStats.store = new StoreStats();
            this.commonStats.fieldData = new FieldDataStats();
            this.commonStats.queryCache = new QueryCacheStats();
            this.commonStats.completion = new CompletionStats();
            this.commonStats.segments = new SegmentsStats();
            this.indexStatsMap = new HashMap<String, AggregatedIndexStats>();
            for (ShardStats shardStats : indexShardsStats) {
                AggregatedIndexStats indexShardStats = this.indexStatsMap.get(shardStats.getShardRouting().getIndexName());
                if (indexShardStats == null) {
                    indexShardStats = new AggregatedIndexStats();
                    this.indexStatsMap.put(shardStats.getShardRouting().getIndexName(), indexShardStats);
                }
                ++indexShardStats.total;
                CommonStats shardCommonStats = shardStats.getStats();
                if (shardStats.getShardRouting().primary()) {
                    ++indexShardStats.primaries;
                    this.commonStats.docs.add(shardCommonStats.docs);
                }
                this.commonStats.store.add(shardCommonStats.store);
                this.commonStats.fieldData.add(shardCommonStats.fieldData);
                this.commonStats.queryCache.add(shardCommonStats.queryCache);
                this.commonStats.completion.add(shardCommonStats.completion);
                this.commonStats.segments.add(shardCommonStats.segments);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.commonStats);
            out.writeMap(this.indexStatsMap, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
        }
    }

    @PublicApi(since="2.16.0")
    public static class AggregatedIndexStats
    implements Writeable {
        public int total = 0;
        public int primaries = 0;

        public AggregatedIndexStats(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.primaries = in.readVInt();
        }

        public AggregatedIndexStats() {
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.primaries);
        }
    }
}

