/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.commons.alerting.model.ActionRunResult;
import org.opensearch.commons.alerting.model.MonitorRunResultKt;
import org.opensearch.commons.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.ScriptException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ?2\u00020\u0001:\u0002?@BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u000f\u0010\u0013J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\u0011\u00105\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bH\u00c6\u0003J\u0015\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JU\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u00109\u001a\u00020\u00052\b\u0010:\u001a\u0004\u0018\u00010;H\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\t\u0010>\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006A"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult;", "Lorg/opensearch/commons/alerting/model/QueryLevelTriggerRunResult;", "triggerName", "", "triggered", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "actionResults", "", "Lorg/opensearch/commons/alerting/model/ActionRunResult;", "clusterTriggerResults", "", "Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult$ClusterTriggerResult;", "<init>", "(Ljava/lang/String;ZLjava/lang/Exception;Ljava/util/Map;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getTriggerName", "()Ljava/lang/String;", "setTriggerName", "(Ljava/lang/String;)V", "getTriggered", "()Z", "setTriggered", "(Z)V", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "getActionResults", "()Ljava/util/Map;", "setActionResults", "(Ljava/util/Map;)V", "getClusterTriggerResults", "()Ljava/util/List;", "setClusterTriggerResults", "(Ljava/util/List;)V", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "internalXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "ClusterTriggerResult", "common-utils"})
@SourceDebugExtension(value={"SMAP\nClusterMetricsTriggerRunResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterMetricsTriggerRunResult.kt\norg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1869#2,2:112\n1869#2,2:114\n*S KotlinDebug\n*F\n+ 1 ClusterMetricsTriggerRunResult.kt\norg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult\n*L\n60#1:112,2\n69#1:114,2\n*E\n"})
public final class ClusterMetricsTriggerRunResult
extends QueryLevelTriggerRunResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String triggerName;
    private boolean triggered;
    @Nullable
    private Exception error;
    @NotNull
    private Map<String, ActionRunResult> actionResults;
    @NotNull
    private List<ClusterTriggerResult> clusterTriggerResults;
    @NotNull
    public static final String TRIGGERED_FIELD = "triggered";
    @NotNull
    public static final String ACTION_RESULTS_FIELD = "action_results";
    @NotNull
    public static final String CLUSTER_RESULTS_FIELD = "cluster_results";

    public ClusterMetricsTriggerRunResult(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults, @NotNull List<ClusterTriggerResult> clusterTriggerResults) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        Intrinsics.checkNotNullParameter(clusterTriggerResults, (String)"clusterTriggerResults");
        super(triggerName, triggered, error, actionResults);
        this.triggerName = triggerName;
        this.triggered = triggered;
        this.error = error;
        this.actionResults = actionResults;
        this.clusterTriggerResults = clusterTriggerResults;
    }

    public /* synthetic */ ClusterMetricsTriggerRunResult(String string, boolean bl, Exception exception, Map map, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, bl, exception, map, list);
    }

    @Override
    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.triggerName = string;
    }

    @Override
    public boolean getTriggered() {
        return this.triggered;
    }

    @Override
    public void setTriggered(boolean bl) {
        this.triggered = bl;
    }

    @Override
    @Nullable
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setError(@Nullable Exception exception) {
        this.error = exception;
    }

    @Override
    @NotNull
    public Map<String, ActionRunResult> getActionResults() {
        return this.actionResults;
    }

    @Override
    public void setActionResults(@NotNull Map<String, ActionRunResult> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.actionResults = map;
    }

    @NotNull
    public final List<ClusterTriggerResult> getClusterTriggerResults() {
        return this.clusterTriggerResults;
    }

    public final void setClusterTriggerResults(@NotNull List<ClusterTriggerResult> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.clusterTriggerResults = list;
    }

    public ClusterMetricsTriggerRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = string;
        Exception exception = sin.readException();
        boolean bl = sin.readBoolean();
        Map map = sin.readMap();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        Map map2 = TypeIntrinsics.asMutableMap((Object)map);
        List list = sin.readList(ClusterTriggerResult.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        List list2 = list;
        this(string2, bl, exception, map2, list2);
    }

    @Override
    @Nullable
    public AlertError alertError() {
        if (this.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception);
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.userErrorMessage(exception));
        }
        for (ActionRunResult actionResult : this.getActionResults().values()) {
            if (actionResult.getError() == null) continue;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return new AlertError(instant, "Failed running action:\n" + MonitorRunResultKt.userErrorMessage(actionResult.getError()));
        }
        return null;
    }

    @Override
    @NotNull
    public XContentBuilder internalXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getError() instanceof ScriptException) {
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.script.ScriptException");
            this.setError(new Exception(((ScriptException)exception).toJsonString(), this.getError()));
        }
        XContentBuilder xContentBuilder = builder.field(TRIGGERED_FIELD, this.getTriggered());
        Map<String, ActionRunResult> map = this.getActionResults();
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        xContentBuilder.field(ACTION_RESULTS_FIELD, map).startArray(CLUSTER_RESULTS_FIELD);
        Iterable $this$forEach$iv = this.clusterTriggerResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClusterTriggerResult it = (ClusterTriggerResult)element$iv;
            boolean bl = false;
            it.toXContent(builder, params);
        }
        XContentBuilder xContentBuilder2 = builder.endArray();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endArray(...)");
        return xContentBuilder2;
    }

    @Override
    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeBoolean(this.getTriggered());
        Map<String, ActionRunResult> map = this.getActionResults();
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.commons.alerting.model.ActionRunResult>");
        out.writeMap(map);
        Iterable $this$forEach$iv = this.clusterTriggerResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClusterTriggerResult it = (ClusterTriggerResult)element$iv;
            boolean bl = false;
            it.writeTo(out);
        }
    }

    @NotNull
    public final String component1() {
        return this.triggerName;
    }

    public final boolean component2() {
        return this.triggered;
    }

    @Nullable
    public final Exception component3() {
        return this.error;
    }

    @NotNull
    public final Map<String, ActionRunResult> component4() {
        return this.actionResults;
    }

    @NotNull
    public final List<ClusterTriggerResult> component5() {
        return this.clusterTriggerResults;
    }

    @NotNull
    public final ClusterMetricsTriggerRunResult copy(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults, @NotNull List<ClusterTriggerResult> clusterTriggerResults) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        Intrinsics.checkNotNullParameter(clusterTriggerResults, (String)"clusterTriggerResults");
        return new ClusterMetricsTriggerRunResult(triggerName, triggered, error, actionResults, clusterTriggerResults);
    }

    public static /* synthetic */ ClusterMetricsTriggerRunResult copy$default(ClusterMetricsTriggerRunResult clusterMetricsTriggerRunResult, String string, boolean bl, Exception exception, Map map, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = clusterMetricsTriggerRunResult.triggerName;
        }
        if ((n & 2) != 0) {
            bl = clusterMetricsTriggerRunResult.triggered;
        }
        if ((n & 4) != 0) {
            exception = clusterMetricsTriggerRunResult.error;
        }
        if ((n & 8) != 0) {
            map = clusterMetricsTriggerRunResult.actionResults;
        }
        if ((n & 0x10) != 0) {
            list = clusterMetricsTriggerRunResult.clusterTriggerResults;
        }
        return clusterMetricsTriggerRunResult.copy(string, bl, exception, map, list);
    }

    @NotNull
    public String toString() {
        return "ClusterMetricsTriggerRunResult(triggerName=" + this.triggerName + ", triggered=" + this.triggered + ", error=" + this.error + ", actionResults=" + this.actionResults + ", clusterTriggerResults=" + this.clusterTriggerResults + ")";
    }

    public int hashCode() {
        int result = this.triggerName.hashCode();
        result = result * 31 + Boolean.hashCode(this.triggered);
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        result = result * 31 + ((Object)this.actionResults).hashCode();
        result = result * 31 + ((Object)this.clusterTriggerResults).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClusterMetricsTriggerRunResult)) {
            return false;
        }
        ClusterMetricsTriggerRunResult clusterMetricsTriggerRunResult = (ClusterMetricsTriggerRunResult)other;
        if (!Intrinsics.areEqual((Object)this.triggerName, (Object)clusterMetricsTriggerRunResult.triggerName)) {
            return false;
        }
        if (this.triggered != clusterMetricsTriggerRunResult.triggered) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.error, (Object)clusterMetricsTriggerRunResult.error)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actionResults, clusterMetricsTriggerRunResult.actionResults)) {
            return false;
        }
        return Intrinsics.areEqual(this.clusterTriggerResults, clusterMetricsTriggerRunResult.clusterTriggerResults);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult$ClusterTriggerResult;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "cluster", "", "triggered", "", "<init>", "(Ljava/lang/String;Z)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getCluster", "()Ljava/lang/String;", "getTriggered", "()Z", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
    public static final class ClusterTriggerResult
    implements ToXContentObject,
    Writeable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String cluster;
        private final boolean triggered;

        public ClusterTriggerResult(@NotNull String cluster, boolean triggered) {
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            this.cluster = cluster;
            this.triggered = triggered;
        }

        @NotNull
        public final String getCluster() {
            return this.cluster;
        }

        public final boolean getTriggered() {
            return this.triggered;
        }

        public ClusterTriggerResult(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            String string = sin.readString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            this(string, sin.readBoolean());
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().startObject(this.cluster).field(ClusterMetricsTriggerRunResult.TRIGGERED_FIELD, this.triggered).endObject().endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
            return xContentBuilder;
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.cluster);
            out.writeBoolean(this.triggered);
        }

        @NotNull
        public final String component1() {
            return this.cluster;
        }

        public final boolean component2() {
            return this.triggered;
        }

        @NotNull
        public final ClusterTriggerResult copy(@NotNull String cluster, boolean triggered) {
            Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
            return new ClusterTriggerResult(cluster, triggered);
        }

        public static /* synthetic */ ClusterTriggerResult copy$default(ClusterTriggerResult clusterTriggerResult, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = clusterTriggerResult.cluster;
            }
            if ((n & 2) != 0) {
                bl = clusterTriggerResult.triggered;
            }
            return clusterTriggerResult.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ClusterTriggerResult(cluster=" + this.cluster + ", triggered=" + this.triggered + ")";
        }

        public int hashCode() {
            int result = this.cluster.hashCode();
            result = result * 31 + Boolean.hashCode(this.triggered);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClusterTriggerResult)) {
                return false;
            }
            ClusterTriggerResult clusterTriggerResult = (ClusterTriggerResult)other;
            if (!Intrinsics.areEqual((Object)this.cluster, (Object)clusterTriggerResult.cluster)) {
                return false;
            }
            return this.triggered == clusterTriggerResult.triggered;
        }

        @JvmStatic
        @NotNull
        public static final ClusterTriggerResult readFrom(@NotNull StreamInput sin) throws IOException {
            return Companion.readFrom(sin);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult$ClusterTriggerResult$Companion;", "", "<init>", "()V", "readFrom", "Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult$ClusterTriggerResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ClusterTriggerResult readFrom(@NotNull StreamInput sin) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
                return new ClusterTriggerResult(sin);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult$Companion;", "", "<init>", "()V", "TRIGGERED_FIELD", "", "ACTION_RESULTS_FIELD", "CLUSTER_RESULTS_FIELD", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

