/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.languagetool.JLanguageTool;
import org.languagetool.RuleEntityResolver;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLValidator {
    public XMLValidator() {
        Tools.setPasswordAuthenticator();
    }

    public void validateXMLString(String xml, String dtdFile, String docType) throws SAXException, IOException, ParserConfigurationException {
        this.validateInternal(xml, dtdFile, docType);
    }

    public void validateWithDtd(String filename, String dtdPath, String docType) throws IOException {
        try (InputStream xmlStream = JLanguageTool.getDataBroker().getAsStream(filename);){
            if (xmlStream == null) {
                throw new IOException("Not found in classpath: " + filename);
            }
            try {
                String xml = StringTools.readStream(xmlStream, "utf-8");
                this.validateInternal(xml, dtdPath, docType);
            }
            catch (Exception e) {
                throw new IOException("Cannot load or parse '" + filename + "'", e);
            }
        }
    }

    public void validateWithXmlSchema(String filename, String xmlSchemaPath) throws IOException {
        try (InputStream xmlStream = JLanguageTool.getDataBroker().getAsStream(filename);){
            if (xmlStream == null) {
                throw new IOException("File not found in classpath: " + filename);
            }
            URL schemaUrl = this.getClass().getResource(xmlSchemaPath);
            if (schemaUrl == null) {
                throw new IOException("XML schema not found in classpath: " + xmlSchemaPath);
            }
            this.validateInternal(new StreamSource(xmlStream), schemaUrl, filename);
        }
        catch (Exception e) {
            throw new IOException("Cannot load or parse '" + filename + "'", e);
        }
    }

    public void validateWithXmlSchema(String baseFilename, String filename, String xmlSchemaPath) throws IOException {
        try (InputStream xmlStream = JLanguageTool.getDataBroker().getAsStream(filename);
             InputStream baseXmlStream = JLanguageTool.getDataBroker().getAsStream(baseFilename);){
            if (xmlStream == null) {
                throw new IOException("File not found in classpath: " + filename);
            }
            if (baseXmlStream == null) {
                throw new IOException("File not found in classpath: " + baseFilename);
            }
            URL schemaUrl = this.getClass().getResource(xmlSchemaPath);
            if (schemaUrl == null) {
                throw new IOException("XML schema not found in classpath: " + xmlSchemaPath);
            }
            this.validateInternal(XMLValidator.mergeIntoSource(baseXmlStream, xmlStream, baseFilename), schemaUrl, baseFilename);
        }
        catch (Exception e) {
            throw new IOException("Cannot load or parse '" + filename + "'", e);
        }
    }

    private static Source mergeIntoSource(InputStream baseXmlStream, InputStream xmlStream, String baseXmlPath) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringComments(true);
        domFactory.setValidating(false);
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        ResourceDataBroker broker = JLanguageTool.getDataBroker();
        URL absoluteUrl = broker.getAsURL(baseXmlPath);
        RuleEntityResolver entityResolver = new RuleEntityResolver();
        builder.setEntityResolver(entityResolver);
        Document baseDoc = builder.parse(baseXmlStream);
        Document ruleDoc = builder.parse(xmlStream);
        NodeList unificationNodes = baseDoc.getElementsByTagName("unification");
        Node ruleNode = ruleDoc.getElementsByTagName("rules").item(0);
        Node firstChildRuleNode = ruleNode.getChildNodes().item(1);
        for (int i = 0; i < unificationNodes.getLength(); ++i) {
            Node unificationNode = ruleDoc.importNode(unificationNodes.item(i), true);
            ruleNode.insertBefore(unificationNode, firstChildRuleNode);
        }
        return new DOMSource(ruleDoc);
    }

    public void validateStringWithXmlSchema(String xml, String xmlSchemaPath, String xmlPath) throws IOException {
        try {
            URL schemaUrl = this.getClass().getResource(xmlSchemaPath);
            if (schemaUrl == null) {
                throw new IOException("XML schema not found in classpath: " + xmlSchemaPath);
            }
            try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
                this.validateInternal(new StreamSource(stream), schemaUrl, xmlPath);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateInternal(String xml, String dtdPath, String docType) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        SAXParser saxParser = factory.newSAXParser();
        String cleanXml = xml.replaceAll("<!DOCTYPE.+>", "");
        String decl = "<?xml version=\"1.0\"";
        String endDecl = "?>";
        URL dtdUrl = this.getClass().getResource(dtdPath);
        if (dtdUrl == null) {
            throw new RuntimeException("DTD not found in classpath: " + dtdPath);
        }
        String dtd = "<!DOCTYPE " + docType + " PUBLIC \"-//W3C//DTD Rules 0.1//EN\" \"" + dtdUrl + "\">";
        int pos = cleanXml.indexOf(decl);
        int endPos = cleanXml.indexOf(endDecl);
        if (pos == -1) {
            throw new IOException("No XML declaration found in '" + cleanXml.substring(0, Math.min(100, cleanXml.length())) + "...'");
        }
        String newXML = cleanXml.substring(0, endPos + endDecl.length()) + "\r\n" + dtd + cleanXml.substring(endPos + endDecl.length());
        InputSource is = new InputSource(new StringReader(newXML));
        saxParser.parse(is, (DefaultHandler)new ErrorHandler());
    }

    private void validateInternal(Source xmlSrc, URL xmlSchema, String xmlPath) throws SAXException, IOException {
        Validator validator = this.getValidator(xmlSchema, xmlPath);
        validator.validate(xmlSrc);
    }

    private Validator getValidator(URL xmlSchema, String xmlPath) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(xmlSchema);
        Validator validator = schema.newValidator();
        validator.setResourceResolver(new LSRuleEntityResolver());
        validator.setErrorHandler(new ErrorHandler());
        return validator;
    }

    static class ErrorHandler
    extends DefaultHandler {
        ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            System.err.println(e.getMessage() + " Problem found at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ".");
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            System.err.println(e.getMessage() + " Problem found at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ".");
            throw e;
        }
    }

    static class LSRuleEntityResolver
    implements LSResourceResolver {
        LSRuleEntityResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if (systemId != null && systemId.endsWith(".ent")) {
                try {
                    return new EntityAsInput(publicId, systemId);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    static class EntityAsInput
    implements LSInput {
        private RuleEntityResolver ruleEntityResolver = new RuleEntityResolver();
        private String systemId;
        private String publicId;
        private InputStream inputStream;
        private URL entitiesUrl;

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return this.inputStream;
        }

        @Override
        public void setByteStream(InputStream inputStream) {
        }

        @Override
        public String getStringData() {
            return null;
        }

        public InputStream getInputStream() {
            System.out.println("GET FOO GET FOO");
            return this.inputStream;
        }

        public void setInputStream() throws IOException {
            if (this.systemId != null && this.systemId.endsWith(".ent")) {
                this.inputStream = this.ruleEntityResolver.getInputStreamLTEntities(this.systemId);
            }
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        public EntityAsInput(String publicId, String systemId) throws IOException {
            this.setPublicId(publicId);
            this.setSystemId(systemId);
            this.setInputStream();
        }
    }
}

