# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the ios_bgp_global module
"""


class Bgp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_bgp_global module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "as_number": {"type": "str"},
                "aggregate_addresses": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "netmask": {"type": "str"},
                        "advertise_map": {"type": "str"},
                        "as_confed_set": {"type": "bool"},
                        "as_set": {"type": "bool"},
                        "attribute_map": {"type": "str"},
                        "summary_only": {"type": "bool"},
                        "suppress_map": {"type": "str"},
                    },
                },
                "auto_summary": {"type": "bool"},
                "bgp": {
                    "type": "dict",
                    "options": {
                        "additional_paths": {
                            "type": "dict",
                            "options": {
                                "install": {"type": "bool"},
                                "receive": {"type": "bool"},
                                "select": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "best": {"type": "int"},
                                        "best_external": {"type": "bool"},
                                        "group_best": {"type": "bool"},
                                    },
                                },
                                "send": {"type": "bool"},
                            },
                        },
                        "advertise_best_external": {"type": "bool"},
                        "aggregate_timer": {"type": "int"},
                        "always_compare_med": {"type": "bool"},
                        "asnotation": {"type": "bool"},
                        "bestpath_options": {
                            "type": "dict",
                            "options": {
                                "aigp": {"type": "bool"},
                                "compare_routerid": {"type": "bool"},
                                "cost_community": {"type": "bool"},
                                "igp_metric": {"type": "bool"},
                                "med": {
                                    "type": "dict",
                                    "options": {
                                        "confed": {"type": "bool"},
                                        "missing_as_worst": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "client_to_client": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "all": {"type": "bool"},
                                "intra_cluster": {"type": "str"},
                            },
                        },
                        "cluster_id": {"type": "str"},
                        "confederation": {
                            "type": "dict",
                            "options": {"identifier": {"type": "str"}, "peers": {"type": "str"}},
                        },
                        "consistency_checker": {
                            "type": "dict",
                            "options": {
                                "auto_repair": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "interval": {"type": "int"},
                                    },
                                },
                                "error_message": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "interval": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "dampening": {
                            "type": "dict",
                            "options": {
                                "penalty_half_time": {"type": "int"},
                                "reuse_route_val": {"type": "int"},
                                "suppress_route_val": {"type": "int"},
                                "max_suppress": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "default": {
                            "type": "dict",
                            "apply_defaults": True,
                            "options": {
                                "ipv4_unicast": {"type": "bool", "default": True},
                                "route_target": {
                                    "type": "dict",
                                    "apply_defaults": True,
                                    "options": {
                                        "filter": {"type": "bool", "default": True},
                                    },
                                },
                            },
                        },
                        "deterministic_med": {"type": "bool"},
                        "dmzlink_bw": {"type": "bool"},
                        "enforce_first_as": {"type": "bool"},
                        "enhanced_error": {"type": "bool"},
                        "fast_external_fallover": {"type": "bool"},
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "extended": {"type": "bool"},
                                "restart_time": {"type": "int"},
                                "stalepath_time": {"type": "int"},
                            },
                        },
                        "graceful_shutdown": {
                            "type": "dict",
                            "options": {
                                "neighbors": {
                                    "type": "dict",
                                    "options": {
                                        "time": {"type": "int"},
                                        "activate": {"type": "bool"},
                                    },
                                },
                                "vrfs": {
                                    "type": "dict",
                                    "options": {
                                        "time": {"type": "int"},
                                        "activate": {"type": "bool"},
                                    },
                                },
                                "community": {"type": "str"},
                                "local_preference": {"type": "int"},
                            },
                        },
                        "inject_maps": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "exist_map_name": {"type": "str"},
                                "copy_attributes": {"type": "bool"},
                            },
                        },
                        "listen": {
                            "type": "dict",
                            "options": {
                                "limit": {"type": "int"},
                                "range": {
                                    "type": "dict",
                                    "options": {
                                        "host_with_subnet": {"type": "str"},
                                        "peer_group": {"type": "str"},
                                    },
                                },
                            },
                        },
                        "log_neighbor_changes": {"type": "bool"},
                        "maxas_limit": {"type": "int"},
                        "maxcommunity_limit": {"type": "int"},
                        "maxextcommunity_limit": {"type": "int"},
                        "nexthop": {
                            "type": "dict",
                            "options": {
                                "route_map": {"type": "str"},
                                "trigger": {
                                    "type": "dict",
                                    "options": {
                                        "delay": {"type": "int"},
                                        "enable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "nopeerup_delay_options": {
                            "type": "dict",
                            "options": {
                                "cold_boot": {"type": "int"},
                                "nsf_switchover": {"type": "int"},
                                "post_boot": {"type": "int"},
                                "user_initiated": {"type": "int"},
                            },
                        },
                        "recursion": {"type": "bool"},
                        "redistribute_internal": {"type": "bool"},
                        "refresh": {
                            "type": "dict",
                            "options": {
                                "max_eor_time": {"type": "int"},
                                "stalepath_time": {"type": "int"},
                            },
                        },
                        "regexp": {"type": "bool"},
                        "route_map": {"type": "bool"},
                        "router_id": {
                            "type": "dict",
                            "options": {
                                "address": {"type": "str"},
                                "interface": {"type": "str"},
                                "vrf": {"type": "bool"},
                            },
                        },
                        "scan_time": {"type": "int"},
                        "slow_peer": {
                            "type": "dict",
                            "options": {
                                "detection": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "threshold": {"type": "int"},
                                    },
                                },
                                "split_update_group": {
                                    "type": "dict",
                                    "options": {
                                        "dynamic": {"type": "bool"},
                                        "permanent": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "snmp": {"type": "bool"},
                        "sso": {"type": "bool"},
                        "soft_reconfig_backup": {"type": "bool"},
                        "suppress_inactive": {"type": "bool"},
                        "transport": {"type": "bool"},
                        "update_delay": {"type": "int"},
                        "update_group": {"type": "bool"},
                        "upgrade_cli": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "af_mode": {"type": "bool"}},
                        },
                    },
                },
                "bmp": {
                    "type": "dict",
                    "options": {
                        "buffer_size": {"type": "int"},
                        "initial_refresh": {
                            "type": "dict",
                            "options": {"delay": {"type": "int"}, "skip": {"type": "bool"}},
                        },
                        "server": {"type": "int"},
                        "server_options": {
                            "type": "dict",
                            "options": {
                                "activate": {"type": "bool"},
                                "address": {
                                    "type": "dict",
                                    "options": {"host": {"type": "str"}, "port": {"type": "int"}},
                                },
                            },
                        },
                    },
                },
                "default_information": {"type": "bool"},
                "default_metric": {"type": "int"},
                "distance": {
                    "type": "dict",
                    "options": {
                        "admin": {
                            "type": "dict",
                            "options": {
                                "distance": {"type": "int"},
                                "address": {"type": "str"},
                                "wildcard_bit": {"type": "str"},
                                "acl": {"type": "str"},
                            },
                        },
                        "bgp": {
                            "type": "dict",
                            "options": {
                                "routes_external": {"type": "int"},
                                "routes_internal": {"type": "int"},
                                "routes_local": {"type": "int"},
                            },
                        },
                        "mbgp": {
                            "type": "dict",
                            "options": {
                                "routes_external": {"type": "int"},
                                "routes_internal": {"type": "int"},
                                "routes_local": {"type": "int"},
                            },
                        },
                    },
                },
                "distributes": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "prefix": {"type": "str"},
                        "gateway": {"type": "str"},
                        "acl": {"type": "str"},
                        "in": {"type": "bool"},
                        "out": {"type": "bool"},
                        "interface": {"type": "str"},
                    },
                },
                "maximum_paths": {
                    "type": "dict",
                    "options": {
                        "paths": {"type": "int"},
                        "eibgp": {"type": "int"},
                        "ibgp": {"type": "int"},
                    },
                },
                "maximum_secondary_paths": {
                    "type": "dict",
                    "options": {
                        "paths": {"type": "int"},
                        "eibgp": {"type": "int"},
                        "ibgp": {"type": "int"},
                    },
                },
                "neighbors": {
                    "type": "list",
                    "elements": "dict",
                    "aliases": ["neighbor"],
                    "options": {
                        "neighbor_address": {"type": "str"},
                        "activate": {"type": "bool"},
                        "additional_paths": {
                            "type": "dict",
                            "options": {
                                "disable": {"type": "bool"},
                                "receive": {"type": "bool"},
                                "send": {"type": "bool"},
                            },
                        },
                        "advertise": {
                            "type": "dict",
                            "options": {
                                "additional_paths": {
                                    "type": "dict",
                                    "options": {
                                        "all": {"type": "bool"},
                                        "best": {"type": "int"},
                                        "group_best": {"type": "bool"},
                                    },
                                },
                                "best_external": {"type": "bool"},
                                "diverse_path": {
                                    "type": "dict",
                                    "options": {
                                        "backup": {"type": "bool"},
                                        "mpath": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "advertise_map": {
                            "type": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "exist_map": {"type": "str"},
                                "non_exist_map": {"type": "str"},
                            },
                        },
                        "advertisement_interval": {"type": "int"},
                        "aigp": {
                            "type": "dict",
                            "options": {
                                "enable": {"type": "bool"},
                                "send": {
                                    "type": "dict",
                                    "options": {
                                        "cost_community": {
                                            "type": "dict",
                                            "options": {
                                                "id": {"type": "int"},
                                                "poi": {
                                                    "type": "dict",
                                                    "options": {
                                                        "igp_cost": {"type": "bool"},
                                                        "pre_bestpath": {"type": "bool"},
                                                        "transitive": {"type": "bool"},
                                                    },
                                                },
                                            },
                                        },
                                        "med": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "allow_policy": {"type": "bool"},
                        "allowas_in": {"type": "int"},
                        "as_override": {"type": "bool"},
                        "bmp_activate": {
                            "type": "dict",
                            "options": {"all": {"type": "bool"}, "server": {"type": "int"}},
                        },
                        "capability": {
                            "type": "dict",
                            "options": {
                                "both": {"type": "bool"},
                                "receive": {"type": "bool"},
                                "send": {"type": "bool"},
                            },
                        },
                        "cluster_id": {"type": "str"},
                        "default_originate": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "route_map": {"type": "str"}},
                        },
                        "description": {"type": "str"},
                        "disable_connected_check": {"type": "bool"},
                        "distribute_list": {
                            "type": "dict",
                            "options": {
                                "acl": {"type": "str"},
                                "in": {"type": "bool"},
                                "out": {"type": "bool"},
                            },
                        },
                        "dmzlink_bw": {"type": "bool"},
                        "ebgp_multihop": {
                            "type": "dict",
                            "options": {"enable": {"type": "bool"}, "hop_count": {"type": "int"}},
                        },
                        "fall_over": {
                            "type": "dict",
                            "options": {
                                "bfd": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "multi_hop": {"type": "bool"},
                                        "single_hop": {"type": "bool"},
                                    },
                                },
                                "route_map": {"type": "str"},
                            },
                        },
                        "filter_list": {
                            "type": "dict",
                            "options": {
                                "path_acl": {"type": "str"},
                                "in": {"type": "bool"},
                                "out": {"type": "bool"},
                            },
                        },
                        "ha_mode": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "disable": {"type": "bool"}},
                        },
                        "inherit": {"type": "str"},
                        "local_as": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "number": {"type": "int"},
                                "dual_as": {"type": "bool"},
                                "no_prepend": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "replace_as": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "log_neighbor_changes": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "disable": {"type": "bool"}},
                        },
                        "maximum_prefix": {
                            "type": "dict",
                            "options": {
                                "max_no": {"type": "int"},
                                "threshold_val": {"type": "int"},
                                "restart": {"type": "int"},
                                "warning_only": {"type": "bool"},
                            },
                        },
                        "next_hop_self": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "all": {"type": "bool"}},
                        },
                        "next_hop_unchanged": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "allpaths": {"type": "bool"}},
                        },
                        "password_options": {
                            "type": "dict",
                            "no_log": False,
                            "options": {
                                "encryption": {"type": "int"},
                                "pass_key": {"type": "str", "no_log": True},
                            },
                        },
                        "path_attribute": {
                            "type": "dict",
                            "options": {
                                "discard": {
                                    "type": "dict",
                                    "options": {
                                        "type": {"type": "int"},
                                        "range": {
                                            "type": "dict",
                                            "options": {
                                                "start": {"type": "int"},
                                                "end": {"type": "int"},
                                            },
                                        },
                                        "in": {"type": "bool"},
                                    },
                                },
                                "treat_as_withdraw": {
                                    "type": "dict",
                                    "options": {
                                        "type": {"type": "int"},
                                        "range": {
                                            "type": "dict",
                                            "options": {
                                                "start": {"type": "int"},
                                                "end": {"type": "int"},
                                            },
                                        },
                                        "in": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "peer_group": {"type": "str"},
                        "remote_as": {"type": "str"},
                        "remove_private_as": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "all": {"type": "bool"},
                                "replace_as": {"type": "bool"},
                            },
                        },
                        "route_maps": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "in": {"type": "bool"},
                                "out": {"type": "bool"},
                            },
                        },
                        "route_reflector_client": {"type": "bool"},
                        "route_server_client": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "context": {"type": "str"}},
                        },
                        "send_community": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "both": {"type": "bool"},
                                "extended": {"type": "bool"},
                                "standard": {"type": "bool"},
                            },
                        },
                        "send_label": {
                            "type": "dict",
                            "options": {"set": {"type": "bool"}, "explicit_null": {"type": "bool"}},
                        },
                        "shutdown": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "graceful": {"type": "int"},
                                "community": {"type": "int"},
                                "local_preference": {"type": "bool"},
                            },
                        },
                        "slow_peer": {
                            "type": "dict",
                            "options": {
                                "detection": {
                                    "type": "dict",
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                        "threshold": {"type": "int"},
                                    },
                                },
                                "split_update_group": {
                                    "type": "dict",
                                    "options": {
                                        "dynamic": {
                                            "type": "dict",
                                            "options": {
                                                "enable": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                                "permanent": {"type": "bool"},
                                            },
                                        },
                                        "static": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "soft_reconfiguration": {"type": "bool"},
                        "timers": {
                            "type": "dict",
                            "options": {
                                "interval": {"type": "int"},
                                "holdtime": {"type": "int"},
                                "min_holdtime": {"type": "int"},
                            },
                        },
                        "translate_update": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "nlri": {
                                    "type": "dict",
                                    "options": {
                                        "multicast": {"type": "bool"},
                                        "unicast": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "transport": {
                            "type": "dict",
                            "options": {
                                "connection_mode": {
                                    "type": "dict",
                                    "options": {
                                        "active": {"type": "bool"},
                                        "passive": {"type": "bool"},
                                    },
                                },
                                "multi_session": {"type": "bool"},
                                "path_mtu_discovery": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                    },
                                },
                            },
                        },
                        "ttl_security": {"type": "int"},
                        "unsuppress_map": {"type": "str"},
                        "update_source": {"type": "str"},
                        "version": {"type": "int"},
                        "weight": {"type": "int"},
                    },
                },
                "networks": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "address": {"type": "str"},
                        "netmask": {"type": "str"},
                        "route_map": {"type": "str"},
                        "backdoor": {"type": "bool"},
                    },
                },
                "redistribute": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "application": {
                            "type": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "bgp": {
                            "type": "dict",
                            "options": {
                                "as_number": {"type": "str"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "connected": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "eigrp": {
                            "type": "dict",
                            "options": {
                                "as_number": {"type": "str"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "isis": {
                            "type": "dict",
                            "options": {
                                "area_tag": {"type": "str"},
                                "clns": {"type": "bool"},
                                "ip": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "iso_igrp": {
                            "type": "dict",
                            "options": {"area_tag": {"type": "str"}, "route_map": {"type": "str"}},
                        },
                        "lisp": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "mobile": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "odr": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "ospf": {
                            "type": "dict",
                            "options": {
                                "process_id": {"type": "int"},
                                "match": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                        "nssa_external": {"type": "bool"},
                                        "type_1": {"type": "bool"},
                                        "type_2": {"type": "bool"},
                                    },
                                },
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                                "vrf": {"type": "str"},
                            },
                        },
                        "ospfv3": {
                            "type": "dict",
                            "options": {
                                "process_id": {"type": "int"},
                                "match": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "bool"},
                                        "internal": {"type": "bool"},
                                        "nssa_external": {"type": "bool"},
                                        "type_1": {"type": "bool"},
                                        "type_2": {"type": "bool"},
                                    },
                                },
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "rip": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "static": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "clns": {"type": "bool"},
                                "ip": {"type": "bool"},
                                "metric": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                        },
                        "vrf": {
                            "type": "dict",
                            "options": {"name": {"type": "str"}, "global": {"type": "bool"}},
                        },
                    },
                },
                "synchronization": {"type": "bool"},
                "table_map": {
                    "type": "dict",
                    "options": {"name": {"type": "str"}, "filter": {"type": "bool"}},
                },
                "template": {
                    "type": "dict",
                    "options": {"peer_policy": {"type": "str"}, "peer_session": {"type": "str"}},
                },
                "timers": {
                    "type": "dict",
                    "options": {
                        "keepalive": {"type": "int"},
                        "holdtime": {"type": "int"},
                        "min_holdtime": {"type": "int"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "purged",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
