﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticloadbalancing/ElasticLoadBalancingRequest.h>
#include <aws/elasticloadbalancing/ElasticLoadBalancing_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ElasticLoadBalancing {
namespace Model {

/**
 * <p>Contains the parameters for DescribeLoadBalancerPolicies.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPoliciesInput">AWS
 * API Reference</a></p>
 */
class DescribeLoadBalancerPoliciesRequest : public ElasticLoadBalancingRequest {
 public:
  AWS_ELASTICLOADBALANCING_API DescribeLoadBalancerPoliciesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeLoadBalancerPolicies"; }

  AWS_ELASTICLOADBALANCING_API Aws::String SerializePayload() const override;

 protected:
  AWS_ELASTICLOADBALANCING_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The name of the load balancer.</p>
   */
  inline const Aws::String& GetLoadBalancerName() const { return m_loadBalancerName; }
  inline bool LoadBalancerNameHasBeenSet() const { return m_loadBalancerNameHasBeenSet; }
  template <typename LoadBalancerNameT = Aws::String>
  void SetLoadBalancerName(LoadBalancerNameT&& value) {
    m_loadBalancerNameHasBeenSet = true;
    m_loadBalancerName = std::forward<LoadBalancerNameT>(value);
  }
  template <typename LoadBalancerNameT = Aws::String>
  DescribeLoadBalancerPoliciesRequest& WithLoadBalancerName(LoadBalancerNameT&& value) {
    SetLoadBalancerName(std::forward<LoadBalancerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The names of the policies.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPolicyNames() const { return m_policyNames; }
  inline bool PolicyNamesHasBeenSet() const { return m_policyNamesHasBeenSet; }
  template <typename PolicyNamesT = Aws::Vector<Aws::String>>
  void SetPolicyNames(PolicyNamesT&& value) {
    m_policyNamesHasBeenSet = true;
    m_policyNames = std::forward<PolicyNamesT>(value);
  }
  template <typename PolicyNamesT = Aws::Vector<Aws::String>>
  DescribeLoadBalancerPoliciesRequest& WithPolicyNames(PolicyNamesT&& value) {
    SetPolicyNames(std::forward<PolicyNamesT>(value));
    return *this;
  }
  template <typename PolicyNamesT = Aws::String>
  DescribeLoadBalancerPoliciesRequest& AddPolicyNames(PolicyNamesT&& value) {
    m_policyNamesHasBeenSet = true;
    m_policyNames.emplace_back(std::forward<PolicyNamesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_loadBalancerName;

  Aws::Vector<Aws::String> m_policyNames;
  bool m_loadBalancerNameHasBeenSet = false;
  bool m_policyNamesHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticLoadBalancing
}  // namespace Aws
