﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/EbsSnapshotPreservation.h>
#include <aws/guardduty/model/ScanResourceCriteria.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {
class GetMalwareScanSettingsResult {
 public:
  AWS_GUARDDUTY_API GetMalwareScanSettingsResult() = default;
  AWS_GUARDDUTY_API GetMalwareScanSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GUARDDUTY_API GetMalwareScanSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Represents the criteria to be used in the filter for scanning resources.</p>
   */
  inline const ScanResourceCriteria& GetScanResourceCriteria() const { return m_scanResourceCriteria; }
  template <typename ScanResourceCriteriaT = ScanResourceCriteria>
  void SetScanResourceCriteria(ScanResourceCriteriaT&& value) {
    m_scanResourceCriteriaHasBeenSet = true;
    m_scanResourceCriteria = std::forward<ScanResourceCriteriaT>(value);
  }
  template <typename ScanResourceCriteriaT = ScanResourceCriteria>
  GetMalwareScanSettingsResult& WithScanResourceCriteria(ScanResourceCriteriaT&& value) {
    SetScanResourceCriteria(std::forward<ScanResourceCriteriaT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An enum value representing possible snapshot preservation settings.</p>
   */
  inline EbsSnapshotPreservation GetEbsSnapshotPreservation() const { return m_ebsSnapshotPreservation; }
  inline void SetEbsSnapshotPreservation(EbsSnapshotPreservation value) {
    m_ebsSnapshotPreservationHasBeenSet = true;
    m_ebsSnapshotPreservation = value;
  }
  inline GetMalwareScanSettingsResult& WithEbsSnapshotPreservation(EbsSnapshotPreservation value) {
    SetEbsSnapshotPreservation(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMalwareScanSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ScanResourceCriteria m_scanResourceCriteria;

  EbsSnapshotPreservation m_ebsSnapshotPreservation{EbsSnapshotPreservation::NOT_SET};

  Aws::String m_requestId;
  bool m_scanResourceCriteriaHasBeenSet = false;
  bool m_ebsSnapshotPreservationHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
