﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/shield/Shield_EXPORTS.h>
#include <aws/shield/model/AttackDetail.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Shield {
namespace Model {
class DescribeAttackResult {
 public:
  AWS_SHIELD_API DescribeAttackResult() = default;
  AWS_SHIELD_API DescribeAttackResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SHIELD_API DescribeAttackResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The attack that you requested. </p>
   */
  inline const AttackDetail& GetAttack() const { return m_attack; }
  template <typename AttackT = AttackDetail>
  void SetAttack(AttackT&& value) {
    m_attackHasBeenSet = true;
    m_attack = std::forward<AttackT>(value);
  }
  template <typename AttackT = AttackDetail>
  DescribeAttackResult& WithAttack(AttackT&& value) {
    SetAttack(std::forward<AttackT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeAttackResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AttackDetail m_attack;

  Aws::String m_requestId;
  bool m_attackHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Shield
}  // namespace Aws
