﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resource-explorer-2/ResourceExplorer2_EXPORTS.h>
#include <aws/resource-explorer-2/model/ManagedView.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResourceExplorer2 {
namespace Model {
class GetManagedViewResult {
 public:
  AWS_RESOURCEEXPLORER2_API GetManagedViewResult() = default;
  AWS_RESOURCEEXPLORER2_API GetManagedViewResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESOURCEEXPLORER2_API GetManagedViewResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Details about the specified managed view. </p>
   */
  inline const ManagedView& GetManagedView() const { return m_managedView; }
  template <typename ManagedViewT = ManagedView>
  void SetManagedView(ManagedViewT&& value) {
    m_managedViewHasBeenSet = true;
    m_managedView = std::forward<ManagedViewT>(value);
  }
  template <typename ManagedViewT = ManagedView>
  GetManagedViewResult& WithManagedView(ManagedViewT&& value) {
    SetManagedView(std::forward<ManagedViewT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetManagedViewResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ManagedView m_managedView;

  Aws::String m_requestId;
  bool m_managedViewHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResourceExplorer2
}  // namespace Aws
