﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/EbsInstanceBlockDevice.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes a block device mapping.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/InstanceBlockDeviceMapping">AWS
 * API Reference</a></p>
 */
class InstanceBlockDeviceMapping {
 public:
  AWS_EC2_API InstanceBlockDeviceMapping() = default;
  AWS_EC2_API InstanceBlockDeviceMapping(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API InstanceBlockDeviceMapping& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The device name.</p>
   */
  inline const Aws::String& GetDeviceName() const { return m_deviceName; }
  inline bool DeviceNameHasBeenSet() const { return m_deviceNameHasBeenSet; }
  template <typename DeviceNameT = Aws::String>
  void SetDeviceName(DeviceNameT&& value) {
    m_deviceNameHasBeenSet = true;
    m_deviceName = std::forward<DeviceNameT>(value);
  }
  template <typename DeviceNameT = Aws::String>
  InstanceBlockDeviceMapping& WithDeviceName(DeviceNameT&& value) {
    SetDeviceName(std::forward<DeviceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Parameters used to automatically set up EBS volumes when the instance is
   * launched.</p>
   */
  inline const EbsInstanceBlockDevice& GetEbs() const { return m_ebs; }
  inline bool EbsHasBeenSet() const { return m_ebsHasBeenSet; }
  template <typename EbsT = EbsInstanceBlockDevice>
  void SetEbs(EbsT&& value) {
    m_ebsHasBeenSet = true;
    m_ebs = std::forward<EbsT>(value);
  }
  template <typename EbsT = EbsInstanceBlockDevice>
  InstanceBlockDeviceMapping& WithEbs(EbsT&& value) {
    SetEbs(std::forward<EbsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceName;

  EbsInstanceBlockDevice m_ebs;
  bool m_deviceNameHasBeenSet = false;
  bool m_ebsHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
