/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;
import org.xml.sax.InputSource;

public class XMLFormattingStrategy
extends ContextBasedFormattingStrategy {
    private static final Log log = Log.getLog(XMLFormattingStrategy.class);

    XMLFormattingStrategy() {
    }

    public void formatterStarts(String initialIndentation) {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        if (CommonUtils.isEmpty((String)content)) {
            return content;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (!content.contains("<?xml")) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXSource src = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader(content)));
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(src, result);
            String resultString = result.getWriter().toString();
            if (CommonUtils.isEmpty((String)resultString)) {
                return content;
            }
            return resultString.replaceAll("(?m)^[ \\t]*\\r?\\n", "");
        }
        catch (Throwable e) {
            log.debug((Object)("Error formatting XML: " + e.getMessage()));
            return content;
        }
    }

    public void formatterStops() {
    }
}

