/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.model;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.model.AbstractTabWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.properties.propertymap.PropertyMap;

public class TabWindowItem
extends AbstractTabWindowItem {
    public static final TabWindowProperties emptyProperties = new TabWindowProperties();
    private TabWindowProperties tabWindowProperties;
    private TabWindowProperties parentProperties = emptyProperties;

    public TabWindowItem() {
        this.tabWindowProperties = new TabWindowProperties(emptyProperties);
    }

    public TabWindowItem(TabWindowItem windowItem) {
        super(windowItem);
        this.tabWindowProperties = new TabWindowProperties(windowItem.getTabWindowProperties().getMap().copy(true, true));
        this.tabWindowProperties.getMap().replaceSuperMap(windowItem.getParentTabWindowProperties().getMap(), emptyProperties.getMap());
    }

    @Override
    protected DockingWindow createWindow(ViewReader viewReader, ArrayList childWindows) {
        return childWindows.size() == 0 ? null : viewReader.createTabWindow(childWindows.toArray(new DockingWindow[childWindows.size()]), this);
    }

    public TabWindowProperties getTabWindowProperties() {
        return this.tabWindowProperties;
    }

    public void setTabWindowProperties(TabWindowProperties tabWindowProperties) {
        this.tabWindowProperties = tabWindowProperties;
    }

    public TabWindowProperties getParentTabWindowProperties() {
        return this.parentProperties;
    }

    public void setParentTabWindowProperties(TabWindowProperties parentProperties) {
        this.tabWindowProperties.getMap().replaceSuperMap(this.parentProperties.getMap(), parentProperties.getMap());
        this.parentProperties = parentProperties;
    }

    @Override
    public WindowItem copy() {
        return new TabWindowItem(this);
    }

    @Override
    public void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(1);
        super.write(out, context, viewWriter);
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getTabWindowProperties().getMap();
    }

    @Override
    public void clearWindows() {
    }

    @Override
    public String toString() {
        return "TabWindow: " + super.toString();
    }
}

