/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.infonode.util.ReleaseInfo;

public class ReleaseInfoDialog {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static void showDialog(ReleaseInfo info, String text) {
        String[] stringArray;
        ReleaseInfo[] releaseInfoArray = new ReleaseInfo[]{info};
        if (text == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = text;
        }
        ReleaseInfoDialog.showDialog(releaseInfoArray, stringArray);
    }

    public static void showDialog(ReleaseInfo[] info, String[] text) {
        final JComponent message = ReleaseInfoDialog.constructMessage(info, text);
        JScrollPane scrollPane = new JScrollPane(message, 20, 31){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = message.getPreferredSize();
                int height = (int)d.getHeight();
                return new Dimension((int)d.getWidth() + 50, height < 300 ? (int)super.getPreferredSize().getHeight() : 400);
            }
        };
        message.setBorder(new EmptyBorder(10, 20, 10, 20));
        scrollPane.getViewport().setBackground(Color.white);
        JOptionPane.showMessageDialog(null, scrollPane, "Product Release Information", 1);
    }

    private static JComponent constructMessage(ReleaseInfo[] info, String[] text) {
        Box box = new Box(1);
        int i = 0;
        while (i < info.length) {
            JLabel l = new JLabel("<html><body>" + (text == null || text[i] == null ? "" : String.valueOf(text[i]) + "<br>") + "<table>" + "<tr><td style='font-weight: bold;'>Product Name:</td><td>" + info[i].getProductName() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Version:</td><td>" + info[i].getProductVersion().toString() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Build Time:</td><td>" + DATE_FORMAT.format(new Date(info[i].getBuildTime())) + "</td></tr>" + "<tr><td style='font-weight: bold;'>License:</td><td>" + info[i].getLicense() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Vendor:</td><td>" + info[i].getProductVendor() + "</td></tr>" + "<tr><td style='font-weight: bold;'>Homepage:</td><td>" + info[i].getHomepage() + "</td></tr>" + "</table></body></html>");
            l.setFont(l.getFont().deriveFont(0));
            l.setBorder(new CompoundBorder(new EmptyBorder(0, 0, i == info.length - 1 ? 0 : 10, 0), new TitledBorder(" " + info[i].getProductName() + " ")));
            box.add(l);
            ++i;
        }
        return box;
    }
}

