/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.infonode.gui.icon.IconUtil;

public class TextIconListCellRenderer
extends DefaultListCellRenderer {
    private ListCellRenderer renderer;
    private Icon emptyIcon;
    private int width;
    private int gap = -1;

    public TextIconListCellRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
    }

    public void calculateMaximumIconWidth(Object[] list) {
        this.width = IconUtil.getMaxIconWidth(list);
        this.emptyIcon = this.width == 0 ? null : new Icon(){

            @Override
            public int getIconHeight() {
                return 1;
            }

            @Override
            public int getIconWidth() {
                return TextIconListCellRenderer.this.width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        };
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Icon icon;
        if (index == -1) {
            return null;
        }
        JLabel label = (JLabel)this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (this.gap < 0) {
            this.gap = label.getIconTextGap();
        }
        if ((icon = IconUtil.getIcon(value)) == null) {
            label.setIcon(this.emptyIcon);
        } else {
            label.setIcon(icon);
            label.setIconTextGap(this.gap + this.width - icon.getIconWidth());
        }
        return label;
    }
}

