/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;

public class GradientTabAreaBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private GradientComponentPainter painter;

    public GradientTabAreaBorder(Color topColor) {
        this(topColor, null);
    }

    public GradientTabAreaBorder(Color topColor, Color bottomColor) {
        this(ColorProviderUtil.getColorProvider(topColor, UIManagerColorProvider.CONTROL_COLOR), ColorProviderUtil.getColorProvider(bottomColor, UIManagerColorProvider.CONTROL_COLOR));
    }

    public GradientTabAreaBorder(ColorProvider topColorProvider, ColorProvider bottomColorProvider) {
        this.painter = new GradientComponentPainter(topColorProvider, topColorProvider, bottomColorProvider, bottomColorProvider);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int width, int height) {
        TabbedPanel tp = TabbedUtils.getParentTabbedPanel(component);
        if (tp == null) {
            return;
        }
        this.painter.paint(component, g, x, y, width, height, tp.getProperties().getTabAreaOrientation().getNextCW(), false, false);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 0, 0);
    }
}

