/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.FixedTransformComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.gui.shaped.border.RoundedCornerBorder;
import net.infonode.properties.base.Property;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.util.ColorUtil;

public class SoftBlueIceTheme
extends TabbedPanelTitledTabTheme {
    public static final FixedColorProvider DEFAULT_DARK_COLOR = new FixedColorProvider(ColorUtil.mult(new Color(160, 170, 190), 0.9));
    public static final FixedColorProvider DEFAULT_LIGHT_COLOR = new FixedColorProvider(new Color(220, 230, 240));
    private ColorProvider darkColor;
    private ColorProvider lightColor;
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();

    public SoftBlueIceTheme() {
        this(DEFAULT_DARK_COLOR, DEFAULT_LIGHT_COLOR, 4);
    }

    public SoftBlueIceTheme(ColorProvider darkColor, ColorProvider lightColor, int cornerType) {
        RoundedCornerBorder roundedBorder;
        this.darkColor = darkColor;
        this.lightColor = lightColor;
        ColorProvider light = lightColor;
        ColorBlender dark = new ColorBlender(darkColor, lightColor, 0.3f);
        ColorBlender dark2 = new ColorBlender(darkColor, FixedColorProvider.WHITE, 0.1f);
        ColorProvider dark3 = darkColor;
        RoundedCornerBorder tabNormalBorder = roundedBorder = new RoundedCornerBorder(dark3, light, cornerType, cornerType, cornerType, cornerType, true, true, true, true);
        RoundedCornerBorder contentBorder = new RoundedCornerBorder(dark3, light, cornerType, cornerType, cornerType, cornerType, false, true, true, true);
        FixedTransformComponentPainter areaPainter = new FixedTransformComponentPainter(new GradientComponentPainter(dark2, light, light, dark2));
        FixedTransformComponentPainter contentPainter = new FixedTransformComponentPainter(new GradientComponentPainter(light, dark2, dark2, light));
        FixedTransformComponentPainter highlightPainter = new FixedTransformComponentPainter(new GradientComponentPainter(FixedColorProvider.WHITE, light, light, light));
        FixedTransformComponentPainter normalPainter = new FixedTransformComponentPainter(new GradientComponentPainter(light, dark, dark, dark));
        this.tabbedPanelProperties.setPaintTabAreaShadow(true).setTabSpacing(2).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaProperties().getComponentProperties().setBorder(roundedBorder).setInsets(new Insets(2, 2, 3, 3));
        this.tabbedPanelProperties.getTabAreaProperties().getShapedPanelProperties().setClipChildren(true).setComponentPainter(areaPainter).setOpaque(false);
        this.tabbedPanelProperties.getTabAreaComponentsProperties().setStretchEnabled(true).getComponentProperties().setBorder(null).setInsets(new Insets(0, 0, 0, 0));
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getShapedPanelProperties().setOpaque(false);
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder(contentBorder).setInsets(new Insets(3, 3, 4, 4));
        this.tabbedPanelProperties.getContentPanelProperties().getShapedPanelProperties().setComponentPainter(contentPainter).setClipChildren(true).setOpaque(false);
        this.titledTabProperties.setHighlightedRaised(0);
        Font font = this.titledTabProperties.getNormalProperties().getComponentProperties().getFont();
        if (font != null) {
            font = font.deriveFont(0).deriveFont(11.0f);
        }
        this.titledTabProperties.getNormalProperties().getComponentProperties().setBorder(tabNormalBorder).setInsets(new Insets(1, 4, 2, 5)).setBackgroundColor(this.titledTabProperties.getHighlightedProperties().getComponentProperties().getBackgroundColor()).setFont(font);
        this.titledTabProperties.getNormalProperties().getShapedPanelProperties().setComponentPainter(normalPainter).setOpaque(false);
        Property[] linkedProperties = new Property[]{ComponentProperties.BORDER, ComponentProperties.INSETS, ComponentProperties.FONT};
        int i = 0;
        while (i < linkedProperties.length) {
            this.titledTabProperties.getHighlightedProperties().getComponentProperties().getMap().createRelativeRef(linkedProperties[i], this.titledTabProperties.getNormalProperties().getComponentProperties().getMap(), linkedProperties[i]);
            ++i;
        }
        this.titledTabProperties.getHighlightedProperties().getShapedPanelProperties().setComponentPainter(highlightPainter);
    }

    @Override
    public String getName() {
        return "Soft Blue Ice Theme";
    }

    @Override
    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    @Override
    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public ColorProvider getDarkColor() {
        return this.darkColor;
    }

    public ColorProvider getLightColor() {
        return this.lightColor;
    }
}

