/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection.notifymap;

import java.util.ArrayList;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.ConstVectorMap;
import net.infonode.util.collection.map.MapAdapter;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;
import net.infonode.util.collection.notifymap.AbstractConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ConstChangeNotifyMap;
import net.infonode.util.signal.Signal;
import net.infonode.util.signal.SignalListener;

public class ConstChangeNotifyVectorMap
extends AbstractConstChangeNotifyMap {
    private ConstVectorMap vectorMap = new ConstVectorMap();
    private ArrayList mapListeners;

    @Override
    protected void firstListenerAdded() {
        this.mapListeners = new ArrayList(this.vectorMap.getMapCount() + 2);
        int i = 0;
        while (i < this.vectorMap.getMapCount()) {
            this.addMapListener(i);
            ++i;
        }
    }

    @Override
    protected void lastListenerRemoved() {
        int i = this.vectorMap.getMapCount() - 1;
        while (i >= 0) {
            this.removeMapListener(i);
            --i;
        }
        this.mapListeners = null;
    }

    private Object getValue(Object key, int fromIndex, int toIndex) {
        int i = fromIndex;
        while (i < toIndex) {
            Object value = this.getMap(i).get(key);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public int getMapIndex(ConstMap map) {
        return this.vectorMap.getMapIndex(map);
    }

    public void addMap(ConstChangeNotifyMap map) {
        this.addMap(this.vectorMap.getMapCount(), map);
    }

    public void addMap(int index, ConstChangeNotifyMap map) {
        this.vectorMap.addMap(index, map);
        if (this.getChangeSignalInternal().hasListeners()) {
            this.addMapListener(index);
            MapAdapter changes = new MapAdapter();
            ConstMapIterator iterator = map.constIterator();
            while (iterator.atEntry()) {
                Object value = this.getValue(iterator.getKey(), 0, index);
                if (value == null) {
                    Object mapValue = iterator.getValue();
                    changes.put(iterator.getKey(), new ValueChange(this.getValue(iterator.getKey(), index + 1, this.getMapCount()), mapValue));
                }
                iterator.next();
            }
            this.fireEntriesChanged(changes);
        }
    }

    private void addMapListener(int index) {
        if (this.mapListeners == null) {
            this.mapListeners = new ArrayList(index + 2);
        }
        final ConstChangeNotifyMap map = this.getMap(index);
        SignalListener mapListener = new SignalListener(){

            @Override
            public void signalEmitted(Signal signal, Object object) {
                ConstMap changes = (ConstMap)object;
                MapAdapter changes2 = new MapAdapter();
                int index = ConstChangeNotifyVectorMap.this.getMapIndex(map);
                ConstMapIterator iterator = changes.constIterator();
                while (iterator.atEntry()) {
                    Object value = ConstChangeNotifyVectorMap.this.getValue(iterator.getKey(), 0, index);
                    if (value == null) {
                        ValueChange vc = (ValueChange)iterator.getValue();
                        changes2.put(iterator.getKey(), vc.getOldValue() == null ? new ValueChange(ConstChangeNotifyVectorMap.this.getValue(iterator.getKey(), index + 1, ConstChangeNotifyVectorMap.this.getMapCount()), vc.getNewValue()) : (vc.getNewValue() == null ? new ValueChange(vc.getOldValue(), ConstChangeNotifyVectorMap.this.getValue(iterator.getKey(), index + 1, ConstChangeNotifyVectorMap.this.getMapCount())) : vc));
                    }
                    iterator.next();
                }
                ConstChangeNotifyVectorMap.this.fireEntriesChanged(changes2);
            }
        };
        this.mapListeners.add(index, mapListener);
        map.getChangeSignal().add(mapListener);
    }

    private void removeMapListener(int index) {
        ConstChangeNotifyMap map = this.getMap(index);
        map.getChangeSignal().remove((SignalListener)this.mapListeners.get(index));
        this.mapListeners.remove(index);
    }

    public int getMapCount() {
        return this.vectorMap.getMapCount();
    }

    public void removeMap(int index) {
        if (this.getChangeSignalInternal().hasListeners()) {
            this.removeMapListener(index);
        }
        ConstMap map = this.vectorMap.removeMap(index);
        if (this.getChangeSignalInternal().hasListeners()) {
            MapAdapter changes = new MapAdapter();
            ConstMapIterator iterator = map.constIterator();
            while (iterator.atEntry()) {
                Object value = this.getValue(iterator.getKey(), 0, index);
                if (value == null) {
                    Object mapValue = iterator.getValue();
                    changes.put(iterator.getKey(), new ValueChange(mapValue, this.getValue(iterator.getKey(), index, this.getMapCount())));
                }
                iterator.next();
            }
            this.fireEntriesChanged(changes);
        }
    }

    @Override
    public Object get(Object key) {
        return this.vectorMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.vectorMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.vectorMap.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.vectorMap.isEmpty();
    }

    public ConstChangeNotifyMap getMap(int index) {
        return (ConstChangeNotifyMap)this.vectorMap.getMap(index);
    }

    @Override
    public ConstMapIterator constIterator() {
        return this.vectorMap.constIterator();
    }
}

