/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.undo;

import java.util.Arrays;
import java.util.List;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class SelectionActor
implements IActor {
    private final String[] nodeIDs;
    private final MapModel map;
    private static SelectionActor lastSelectionActor = null;

    static SelectionActor create(IMapSelection selection) {
        SelectionActor selectionActor = new SelectionActor(selection);
        if (!selectionActor.equals(lastSelectionActor)) {
            lastSelectionActor = selectionActor;
        }
        return lastSelectionActor;
    }

    private SelectionActor(IMapSelection selection) {
        this.map = selection.getSelected().getMap();
        List<NodeModel> nodes = selection.getOrderedSelection();
        this.nodeIDs = new String[nodes.size()];
        int index = 0;
        for (NodeModel node : nodes) {
            this.nodeIDs[index++] = node.createID();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        result = 31 * result + Arrays.hashCode(this.nodeIDs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionActor other = (SelectionActor)obj;
        if (!this.map.equals(other.map)) {
            return false;
        }
        return Arrays.equals(this.nodeIDs, other.nodeIDs);
    }

    @Override
    public void act() {
        this.restoreSelection();
    }

    private void restoreSelection() {
        Controller controller = Controller.getCurrentController();
        if (!this.map.equals(controller.getMap())) {
            return;
        }
        IMapSelection selection = controller.getSelection();
        if (this.equals(new SelectionActor(selection))) {
            return;
        }
        NodeModel[] nodes = new NodeModel[this.nodeIDs.length];
        int index = 0;
        for (String id : this.nodeIDs) {
            nodes[index++] = this.map.getNodeForID(id);
        }
        selection.replaceSelection(nodes);
    }

    @Override
    public String getDescription() {
        return "Restore selection";
    }

    @Override
    public void undo() {
        this.restoreSelection();
    }
}

