/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.security.AccessControlException;
import org.freeplane.core.ui.components.SafeRunner;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.HtmlSelection;

public class ClipboardAccessor {
    private static final ClipboardAccessor INSTANCE = new ClipboardAccessor();
    private Clipboard clipboard;
    private Clipboard selection;

    @Deprecated
    public static ClipboardAccessor getController() {
        return ClipboardAccessor.getInstance();
    }

    public static ClipboardAccessor getInstance() {
        return INSTANCE;
    }

    private ClipboardAccessor() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!GraphicsEnvironment.isHeadless()) {
                this.selection = toolkit.getSystemSelection();
                this.clipboard = toolkit.getSystemClipboard();
            } else {
                this.selection = null;
                this.clipboard = null;
            }
        }
        catch (AccessControlException e) {
            LogUtils.warn("can not access system clipboard, clipboard controller disabled");
        }
    }

    public Transferable getClipboardContents() {
        if (this.clipboard != null) {
            try {
                return this.clipboard.getContents(this);
            }
            catch (IllegalStateException | NullPointerException e) {
                LogUtils.warn("can not access clipboard contents");
            }
        }
        return null;
    }

    public void setClipboardContents(Transferable t) {
        if (this.clipboard != null) {
            SafeRunner.run(5, () -> this.clipboard.setContents(t, null));
        }
        if (this.selection != null) {
            SafeRunner.run(5, () -> this.selection.setContents(t, null));
        }
    }

    public void setClipboardContents(String string) {
        this.setClipboardContents(new StringSelection(string));
    }

    public void setClipboardContentsToHtml(String html) {
        this.setClipboardContents(new HtmlSelection(html));
    }
}

