/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.edge;

import java.awt.Color;
import java.util.ArrayList;
import java.util.WeakHashMap;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.edge.EdgeColorConfiguration;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;

public class EdgeColorsConfigurationFactory {
    public static final String EDGE_COLOR_CONFIGURATION_PROPERTY = "edgeColorConfiguration";
    private static final WeakHashMap<String, EdgeColorConfiguration> configurations = new WeakHashMap();
    private ModeController modeController;

    public EdgeColorsConfigurationFactory(ModeController modeController) {
        this.modeController = modeController;
    }

    public EdgeColorConfiguration create(MapModel map) {
        MapStyleModel mapStyle = MapStyleModel.getExtension(map);
        String configurationString = mapStyle.getProperty(EDGE_COLOR_CONFIGURATION_PROPERTY);
        if (configurationString != null) {
            return this.load(configurationString);
        }
        EdgeColorConfiguration newConfiguration = this.createNewConfiguration(map);
        String newConfigurationString = this.save(newConfiguration);
        mapStyle.setProperty(EDGE_COLOR_CONFIGURATION_PROPERTY, newConfigurationString);
        configurations.put(newConfigurationString, newConfiguration);
        return newConfiguration;
    }

    private EdgeColorConfiguration createNewConfiguration(MapModel map) {
        NodeModel styleNode;
        ArrayList<Color> colors = new ArrayList<Color>();
        AutomaticLayoutController automaticLayoutController = this.modeController.getExtension(AutomaticLayoutController.class);
        EdgeController edgeController = this.modeController.getExtension(EdgeController.class);
        int levelStyleCounter = 0;
        while ((styleNode = automaticLayoutController.getStyleNode(map, levelStyleCounter)) != null) {
            colors.add(edgeController.getColor(styleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
            ++levelStyleCounter;
        }
        return new EdgeColorConfiguration(colors);
    }

    private EdgeColorConfiguration load(String configurationString) {
        EdgeColorConfiguration knownConfiguration = configurations.get(configurationString);
        if (knownConfiguration != null) {
            return knownConfiguration;
        }
        String[] colorStrings = configurationString.split(",");
        ArrayList<Color> colors = new ArrayList<Color>(colorStrings.length);
        for (String color : colorStrings) {
            colors.add(ColorUtils.stringToColor(color));
        }
        EdgeColorConfiguration edgeColorConfiguration = new EdgeColorConfiguration(colors);
        configurations.put(configurationString, knownConfiguration);
        return edgeColorConfiguration;
    }

    public String save(EdgeColorConfiguration configuration) {
        StringBuilder sb = new StringBuilder();
        for (Color color : configuration.colors) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(ColorUtils.colorToRGBAString(color));
        }
        return sb.toString();
    }

    public void setConfiguration(MapModel map, EdgeColorConfiguration edgeColorConfiguration) {
        String serializedConfiguration = this.save(edgeColorConfiguration);
        this.modeController.getExtension(MapStyle.class).setProperty(map, EDGE_COLOR_CONFIGURATION_PROPERTY, serializedConfiguration);
        configurations.put(serializedConfiguration, edgeColorConfiguration);
    }
}

