/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.AFilterComposerDialog;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterConditions;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.styles.ConditionalStyleModel;

public class FilterComposerDialog
extends AFilterComposerDialog {
    private final List<ASelectableCondition> conditions = new LinkedList<ASelectableCondition>();
    private FilterConditions model;

    public FilterComposerDialog(FilterConditionEditor.Variant variant) {
        this(variant, null);
    }

    public FilterComposerDialog(FilterConditionEditor.Variant variant, ConditionalStyleModel context) {
        super(TextUtils.getText("filter_dialog"), true, variant, context);
    }

    @Override
    protected FilterConditions createModel() {
        this.conditions.clear();
        this.initializeModel();
        return this.model;
    }

    protected void initializeModel() {
        if (this.model == null) {
            this.model = new FilterConditions(new DefaultComboBoxModel<ASelectableCondition>(), 0);
        }
    }

    @Override
    protected boolean isSelectionValid(int[] selectedIndices) {
        return selectedIndices.length == 1;
    }

    @Override
    protected void applyModel(FilterConditions model, int[] selectedIndices) {
        if (this.model != model || selectedIndices.length != 1) {
            throw new IllegalArgumentException();
        }
        this.conditions.clear();
        for (int i : selectedIndices) {
            this.conditions.add(model.getElementAt(i));
        }
    }

    public List<ASelectableCondition> getConditions() {
        return this.conditions;
    }

    public void addCondition(ASelectableCondition value) {
        this.initializeModel();
        if (this.model.getIndexOf(value) == -1) {
            this.model.addElement(value);
        }
    }

    public ASelectableCondition editCondition(ASelectableCondition value) {
        this.initializeModel();
        if (value != null) {
            this.setSelectedItem(value);
        }
        this.show();
        List<ASelectableCondition> conditions = this.getConditions();
        if (this.isSuccess()) {
            return conditions.isEmpty() ? null : conditions.get(0);
        }
        return value;
    }
}

