/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.features.filter.ApplyNamedFilterAction;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.mode.Controller;

public class FilterMenuBuilder
implements EntryVisitor {
    private final FilterController filterController;
    private final Controller controller;

    FilterMenuBuilder(Controller controller, FilterController filterController) {
        this.controller = controller;
        this.filterController = filterController;
    }

    @Override
    public void visit(Entry target) {
        DefaultComboBoxModel filterConditions = this.filterController.getFilterConditions();
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < filterConditions.getSize(); ++i) {
            ASelectableCondition condition = (ASelectableCondition)filterConditions.getElementAt(i);
            String conditionName = condition.getUserName();
            if (conditionName == null || !usedNames.add(conditionName)) continue;
            ApplyNamedFilterAction action = new ApplyNamedFilterAction(this.filterController, condition);
            this.controller.addActionIfNotAlreadySet(action);
            new EntryAccessor().addChildAction(target, action);
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return true;
    }

    public void updateMenus() {
        IUserInputListenerFactory userInputListenerFactory = Controller.getCurrentModeController().getUserInputListenerFactory();
        userInputListenerFactory.rebuildMenus("filterConditions");
    }
}

