/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.freeplane.features.icon.TreeTagChangeListener;

class TreeInverseMap<V>
implements TreeModelListener,
TreeTagChangeListener<V> {
    private HashMap<V, Set<DefaultMutableTreeNode>> keysToNodesMap = new HashMap();
    private DefaultTreeModel treeModel;
    private final Function<DefaultMutableTreeNode, V> keyFunction;

    public TreeInverseMap(DefaultTreeModel treeModel, Function<DefaultMutableTreeNode, V> keyFunction) {
        this.treeModel = treeModel;
        this.keyFunction = keyFunction;
        this.treeModel.addTreeModelListener(this);
        this.buildInverseMap();
    }

    private void buildInverseMap() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.traverseAndMapChildren(rootNode);
    }

    private void traverseAndMap(DefaultMutableTreeNode node) {
        this.addToMap(node);
        this.traverseAndMapChildren(node);
    }

    private void traverseAndRemove(DefaultMutableTreeNode node) {
        this.removeFromMap(node);
        this.traverseAndRemoveChildren(node);
    }

    private void traverseAndMapChildren(DefaultMutableTreeNode node) {
        int addedNodeCount = node.getParent() == null ? node.getChildCount() - 1 : node.getChildCount();
        for (int i = 0; i < addedNodeCount; ++i) {
            this.traverseAndMap((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void traverseAndRemoveChildren(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.traverseAndRemove((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void addToMap(DefaultMutableTreeNode node) {
        V key = this.keyFunction.apply(node);
        this.addToMap(key, node);
    }

    private boolean addToMap(V userObject, DefaultMutableTreeNode node) {
        return this.keysToNodesMap.computeIfAbsent((Set)userObject, (Function<Set, Set<DefaultMutableTreeNode>>)((Function<Object, Set>)k -> new HashSet())).add(node);
    }

    private void removeFromMap(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        Set<DefaultMutableTreeNode> nodes = this.keysToNodesMap.get(userObject);
        if (nodes != null) {
            nodes.remove(node);
            if (nodes.isEmpty()) {
                this.keysToNodesMap.remove(userObject);
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        Object[] children;
        for (Object child : children = e.getChildren()) {
            this.traverseAndMap((DefaultMutableTreeNode)child);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        Object[] children;
        for (Object child : children = e.getChildren()) {
            this.traverseAndRemove((DefaultMutableTreeNode)child);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.keysToNodesMap.clear();
        this.buildInverseMap();
    }

    public Set<DefaultMutableTreeNode> getNodes(V userObject) {
        return this.keysToNodesMap.getOrDefault(userObject, Collections.emptySet());
    }

    @Override
    public void valueForPathChanged(TreePath path, V newValue) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.removeFromMap(node);
        this.addToMap(newValue, node);
    }
}

