/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.link.HyperLinkCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class HyperLinkEqualsCondition
extends HyperLinkCondition {
    public static final String NAME = "hyper_link_equals";
    private final StringMatchingStrategy stringMatchingStrategy;

    public HyperLinkEqualsCondition(String hyperlink, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(hyperlink, matchCase, matchApproximately, false, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkLink(Hyperlink nodeLink) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(nodeLink), StringMatchingStrategy.Type.ALL);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_link");
        String simpleCondition = TextUtils.getText(ConditionFactory.FILTER_IS_EQUAL_TO);
        return this.createDescription(condition, simpleCondition, this.getHyperlink());
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String condition = TextUtils.getText("filter_link");
        return this.createRenderedIcons(condition, ConditionFactory.ConditionOperator.FILTER_IS_EQUAL_TO, this.getHyperlink(), fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
    }
}

