/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.icons;

import java.util.stream.Stream;
import org.freeplane.features.link.icons.DecorationRuleMatcher;

class ContainsMatcher
implements DecorationRuleMatcher {
    private final String[] patterns;
    private final int totalLength;

    public ContainsMatcher(String pattern) {
        this.patterns = pattern.split("\\*");
        this.totalLength = Stream.of(this.patterns).mapToInt(String::length).sum();
    }

    @Override
    public int getMaximalMatchLength() {
        return this.totalLength;
    }

    @Override
    public int getMatchLength(String matchedString) {
        if (this.totalLength == 0) {
            return 0;
        }
        String startPattern = this.patterns[0];
        if (!matchedString.startsWith(startPattern)) {
            return 0;
        }
        int lastPatternIndex = this.patterns.length - 1;
        if (lastPatternIndex == 0) {
            return this.totalLength;
        }
        String endPattern = this.patterns[lastPatternIndex];
        if (!matchedString.endsWith(endPattern)) {
            return 0;
        }
        if (lastPatternIndex == 1) {
            return this.totalLength;
        }
        int startPosition = startPattern.length();
        int endPosition = matchedString.length() - endPattern.length();
        int position = startPosition;
        for (int patternIndex = 1; patternIndex < lastPatternIndex; ++patternIndex) {
            if ((position = matchedString.indexOf(this.patterns[patternIndex], position)) < startPosition) {
                return 0;
            }
            if ((position += this.patterns[patternIndex].length()) <= endPosition) continue;
            return 0;
        }
        return this.totalLength;
    }

    public String toString() {
        return "ContainsMatcher [" + String.join((CharSequence)"*", this.patterns) + "]";
    }
}

