/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.features.icon.NamedIcon;

public class NodeIconSetModel {
    private List<NamedIcon> icons;
    private List<String> tags;
    private Quantity<LengthUnit> iconSize = null;

    public void setIconSize(Quantity<LengthUnit> iconSize) {
        this.iconSize = iconSize;
    }

    public Quantity<LengthUnit> getIconSize() {
        return this.iconSize;
    }

    void addIcon(NamedIcon icon) {
        this.createIcons();
        this.icons.add(icon);
    }

    void addIcon(NamedIcon icon, int position) {
        this.createIcons();
        if (position > -1) {
            this.icons.add(position, icon);
        } else {
            this.icons.add(icon);
        }
    }

    private void createIcons() {
        if (this.icons == null) {
            this.icons = new ArrayList<NamedIcon>();
        }
    }

    public NamedIcon getIcon(int position) {
        return this.getIcons().get(position);
    }

    List<NamedIcon> getIcons() {
        if (this.icons == null) {
            return Collections.emptyList();
        }
        return this.icons;
    }

    int removeIcon() {
        this.createIcons();
        if (!this.icons.isEmpty()) {
            this.icons.remove(this.icons.size() - 1);
        }
        return this.icons.size();
    }

    int removeIcon(int position) {
        this.createIcons();
        if (position == this.icons.size()) {
            position = this.icons.size() - 1;
        }
        this.icons.remove(position);
        return this.icons.size();
    }
}

