/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;

public class MindMapNodesSelection
implements Transferable,
ClipboardOwner {
    public static final DataFlavor dropCopyActionFlavor;
    public static final DataFlavor dropLinkActionFlavor;
    public static final DataFlavor fileListFlavor;
    public static final DataFlavor htmlFlavor;
    public static final DataFlavor mindMapNodesFlavor;
    public static final DataFlavor mindMapNodeObjectsFlavor;
    public static final DataFlavor mindMapNodeSingleObjectsFlavor;
    private final String htmlContent;
    private final String nodesContent;
    private final String stringContent;
    private int dropActionContent;
    private Collection<NodeModel> nodes;
    private boolean selectionContainsSingleNodes;

    public MindMapNodesSelection(String nodesContent, String stringContent, String htmlContent) {
        this.nodesContent = nodesContent;
        this.stringContent = stringContent;
        this.htmlContent = htmlContent;
        this.dropActionContent = 2;
    }

    public MindMapNodesSelection(String nodesContent) {
        this(nodesContent, null, null);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.stringContent;
        }
        if (flavor.equals(mindMapNodesFlavor)) {
            return this.nodesContent;
        }
        if (flavor.equals(dropCopyActionFlavor) || flavor.equals(dropLinkActionFlavor)) {
            return this.dropActionContent;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return this.htmlContent;
        }
        if (this.containsObjectsFor(flavor)) {
            return this.nodes;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    boolean containsObjectsFor(DataFlavor flavor) {
        return this.nodes != null && (flavor.equals(mindMapNodeObjectsFlavor) && !this.selectionContainsSingleNodes || flavor.equals(mindMapNodeSingleObjectsFlavor) && this.selectionContainsSingleNodes);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])Stream.of(DataFlavor.stringFlavor, mindMapNodesFlavor, htmlFlavor, dropCopyActionFlavor, dropLinkActionFlavor, mindMapNodeObjectsFlavor, mindMapNodeSingleObjectsFlavor).filter(this::isDataFlavorSupported).toArray(DataFlavor[]::new);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.stringFlavor) && this.stringContent != null) {
            return true;
        }
        if (flavor.equals(mindMapNodesFlavor) && this.nodesContent != null) {
            return true;
        }
        if (flavor.equals(dropCopyActionFlavor) && this.dropActionContent == 1) {
            return true;
        }
        if (flavor.equals(dropLinkActionFlavor) && this.dropActionContent == 0x40000000) {
            return true;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return true;
        }
        return this.containsObjectsFor(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDropAction(Integer dropActionContent) {
        this.dropActionContent = dropActionContent;
    }

    public void setNodeObjects(List<NodeModel> collection, boolean selectionContainsSingleNodes) {
        this.nodes = collection;
        this.selectionContainsSingleNodes = selectionContainsSingleNodes;
    }

    static {
        DataFlavor mindMapNodesFlavorInit = null;
        DataFlavor mindMapNodeObjectsFlavorInit = null;
        DataFlavor mindMapNodeSingleObjectsFlavorInit = null;
        DataFlavor htmlFlavorInit = null;
        DataFlavor fileListFlavorInit = null;
        DataFlavor dropCopyActionFlavorInit = null;
        DataFlavor dropLinkActionFlavorInit = null;
        try {
            mindMapNodesFlavorInit = new DataFlavor("text/freeplane-nodes; class=java.lang.String");
            mindMapNodeObjectsFlavorInit = new DataFlavor("application/freeplane-nodes; class=java.util.Collection");
            mindMapNodeSingleObjectsFlavorInit = new DataFlavor("application/freeplane-single-nodes; class=java.util.Collection");
            htmlFlavorInit = new DataFlavor("text/html; class=java.lang.String");
            fileListFlavorInit = new DataFlavor("application/x-java-file-list; class=java.util.List");
            dropCopyActionFlavorInit = new DataFlavor("application/freeplane-drop-copy-action; class=java.lang.Integer");
            dropLinkActionFlavorInit = new DataFlavor("application/freeplane-drop-link-action; class=java.lang.Integer");
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        mindMapNodesFlavor = mindMapNodesFlavorInit;
        mindMapNodeObjectsFlavor = mindMapNodeObjectsFlavorInit;
        mindMapNodeSingleObjectsFlavor = mindMapNodeSingleObjectsFlavorInit;
        htmlFlavor = htmlFlavorInit;
        fileListFlavor = fileListFlavorInit;
        dropCopyActionFlavor = dropCopyActionFlavorInit;
        dropLinkActionFlavor = dropLinkActionFlavorInit;
    }
}

