/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.Image;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.NodeContainsCondition;
import org.freeplane.features.text.NodeMatchesRegexpCondition;
import org.freeplane.features.text.NodeTextCompareCondition;
import org.freeplane.features.text.NoteContainsCondition;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeTextConditionController
implements IElementaryConditionController {
    private final ComboBoxModel values = new DefaultComboBoxModel();

    NodeTextConditionController() {
    }

    @Override
    public boolean canEditValues(Object selectedItem, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals("filter_node") || namedObject.objectEquals("filter_parent_text") || namedObject.objectEquals("filter_details") || namedObject.objectEquals("filter_note") || namedObject.objectEquals("filter_any_text");
    }

    @Override
    public boolean canSelectValues(Object selectedItem, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        String item = (String)((TranslatedObject)selectedItem).getObject();
        return this.createASelectableCondition(item, simpleCondition, value, matchCase, matchApproximately, ignoreDiacritics);
    }

    private ASelectableCondition createASelectableCondition(String item, TranslatedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_CONTAINS)) {
            if (value.equals("")) {
                return null;
            }
            return new NodeContainsCondition(item, value.toString(), matchCase, matchApproximately, false, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_CONTAINS_WORDWISE)) {
            if (value.equals("")) {
                return null;
            }
            return new NodeContainsCondition(item, value.toString(), matchCase, matchApproximately, true, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_REGEXP)) {
            try {
                return new NodeMatchesRegexpCondition(item, value.toString(), matchCase);
            }
            catch (PatternSyntaxException e) {
                UITools.errorMessage(TextUtils.format("wrong_regexp", value, e.getMessage()));
                return null;
            }
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_IS_EQUAL_TO)) {
            return new NodeTextCompareCondition(item, value, matchCase, 0, true, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_IS_NOT_EQUAL_TO)) {
            return new NodeTextCompareCondition(item, value, matchCase, 0, false, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_GT)) {
            return new NodeTextCompareCondition(item, value, matchCase, 1, true, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_GE)) {
            return new NodeTextCompareCondition(item, value, matchCase, -1, false, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_LT)) {
            return new NodeTextCompareCondition(item, value, matchCase, -1, true, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(ConditionFactory.FILTER_LE)) {
            return new NodeTextCompareCondition(item, value, matchCase, 1, false, matchApproximately, ignoreDiacritics);
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<TranslatedObject>(new TranslatedObject[]{TextUtils.createTranslatedString(ConditionFactory.FILTER_CONTAINS), TextUtils.createTranslatedString(ConditionFactory.FILTER_CONTAINS_WORDWISE), TextUtils.createTranslatedString(ConditionFactory.FILTER_IS_EQUAL_TO), TextUtils.createTranslatedString(ConditionFactory.FILTER_IS_NOT_EQUAL_TO), TranslatedObject.literal(ConditionFactory.FILTER_GT), TranslatedObject.literal(ConditionFactory.FILTER_GE), TranslatedObject.literal(ConditionFactory.FILTER_LE), TranslatedObject.literal(ConditionFactory.FILTER_LT), TextUtils.createTranslatedString(ConditionFactory.FILTER_REGEXP)});
    }

    @Override
    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString("filter_any_text"));
        list.addElement(TextUtils.createTranslatedString("filter_node"));
        list.addElement(TextUtils.createTranslatedString("filter_details"));
        list.addElement(TextUtils.createTranslatedString("filter_note"));
        list.addElement(TextUtils.createTranslatedString("filter_parent_text"));
        return list;
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        if (selectedCondition.objectEquals(ConditionFactory.FILTER_CONTAINS) || selectedCondition.objectEquals(ConditionFactory.FILTER_CONTAINS_WORDWISE) || selectedCondition.objectEquals(ConditionFactory.FILTER_REGEXP)) {
            return new FixedBasicComboBoxEditor();
        }
        return FrameController.getTextDateTimeEditor();
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object selectedItem, TranslatedObject simpleCond) {
        return this.values;
    }

    @Override
    public boolean isCaseDependent(Object selectedItem, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public boolean supportsApproximateMatching(Object selectedItem, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("node_contains_condition")) {
            return NodeContainsCondition.loadIgnoreCase(element);
        }
        if (element.getName().equalsIgnoreCase("match_case_node_contains_condition")) {
            return NodeContainsCondition.loadMatchCase(element);
        }
        if (element.getName().equalsIgnoreCase("node_compare_condition")) {
            return NodeTextCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_matches_regexp")) {
            return NodeMatchesRegexpCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("note_contains_condition")) {
            return NoteContainsCondition.loadIgnoreCase(element);
        }
        if (element.getName().equalsIgnoreCase("match_case_note_contains_condition")) {
            return NoteContainsCondition.loadMatchCase(element);
        }
        return null;
    }

    public static Object[] getItemsForComparison(Object nodeItem, NodeModel node) {
        if (nodeItem.equals("filter_any_text")) {
            return new Object[]{NodeTextConditionController.getItemForComparison("filter_node", node), NodeTextConditionController.getItemForComparison("filter_details", node), NodeTextConditionController.getItemForComparison("filter_note", node)};
        }
        return new Object[]{NodeTextConditionController.getItemForComparison(nodeItem, node)};
    }

    private static Object getItemForComparison(Object nodeItem, NodeModel node) {
        NodeModel parentNode;
        Object result = nodeItem.equals("filter_node") ? NodeTextConditionController.transformedObject(node) : (nodeItem.equals("filter_parent_text") ? ((parentNode = node.getParentNode()) == null ? null : NodeTextConditionController.transformedObject(parentNode)) : (nodeItem.equals("filter_details") ? DetailModel.getDetailText(node) : (nodeItem.equals("filter_note") ? NoteModel.getNoteText(node) : null)));
        if (result instanceof String) {
            return HtmlUtils.htmlToPlain((String)result);
        }
        return result;
    }

    private static Object transformedObject(NodeModel node) {
        TextController textController = TextController.getController();
        Object object = textController.withNodeNumbering(false, () -> textController.getTransformedObjectNoThrow(node));
        if (object instanceof Icon || object instanceof Image) {
            object = node.getText();
        }
        if (object instanceof String) {
            return HtmlUtils.htmlToPlain((String)object);
        }
        return object;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        if (selectedCondition.objectEquals(ConditionFactory.FILTER_CONTAINS) || selectedCondition.objectEquals(ConditionFactory.FILTER_CONTAINS_WORDWISE) || selectedCondition.objectEquals(ConditionFactory.FILTER_REGEXP)) {
            return null;
        }
        return new TypedListCellRenderer();
    }
}

