/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.awt.Component;
import java.text.MessageFormat;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class CreationModificationDatePresenter {
    private static final String SHOW_CREATION_MODIFICATION_IN_TOOLTIP_PROPERTY = "show_creation_modification_in_tooltip";
    private static final String SHOW_CREATION_MODIFICATION_IN_STATUS_PROPERTY = "show_creation_modification_in_status";
    private static final Integer CREATION_TOOLTIP = 14;
    public static final String HOOK_NAME = "accessories/plugins/CreationModificationPlugin.properties";
    private static MessageFormat formatter;

    public CreationModificationDatePresenter() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addToolTipProvider(CREATION_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view, ITooltipProvider.TooltipTrigger tooltipTrigger) {
                if (!node.getHistoryInformation().isSet() || !ResourceController.getResourceController().getBooleanProperty(CreationModificationDatePresenter.SHOW_CREATION_MODIFICATION_IN_TOOLTIP_PROPERTY)) {
                    return null;
                }
                CreationModificationDatePresenter.this.initTooltipFormat();
                Object[] messageArguments = CreationModificationDatePresenter.this.getMessageArguments(node);
                String message = formatter.format(messageArguments);
                return message;
            }
        });
        Controller.getCurrentController().getViewController().addStatusInfo(HOOK_NAME, "");
        modeController.getMapController().addNodeSelectionListener(new INodeSelectionListener(){

            @Override
            public void onSelect(NodeModel node) {
                if (!node.getHistoryInformation().isSet() || !ResourceController.getResourceController().getBooleanProperty(CreationModificationDatePresenter.SHOW_CREATION_MODIFICATION_IN_STATUS_PROPERTY)) {
                    return;
                }
                CreationModificationDatePresenter.this.showStatusInfo(node);
            }

            @Override
            public void onDeselect(NodeModel node) {
                CreationModificationDatePresenter.this.hideStatusInfo();
            }
        });
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals(CreationModificationDatePresenter.SHOW_CREATION_MODIFICATION_IN_STATUS_PROPERTY)) {
                    if (Boolean.parseBoolean(newValue)) {
                        NodeModel selected;
                        IMapSelection selection = Controller.getCurrentController().getSelection();
                        if (selection != null && (selected = selection.getSelected()) != null) {
                            CreationModificationDatePresenter.this.showStatusInfo(selected);
                        }
                    } else {
                        CreationModificationDatePresenter.this.hideStatusInfo();
                    }
                }
            }
        });
    }

    private Object[] getMessageArguments(NodeModel node) {
        Object[] messageArguments = new Object[]{node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt()};
        return messageArguments;
    }

    private void initTooltipFormat() {
        if (formatter == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(TextUtils.getText("reminder.Created"));
            sb.append(":  {0,date} {0,time}<br>");
            sb.append(TextUtils.getText("reminder.Modified"));
            sb.append(": {1,date} {1,time}</html>");
            String tooltipFormat = sb.toString();
            formatter = new MessageFormat(tooltipFormat);
        }
    }

    private void showStatusInfo(NodeModel node) {
        this.initTooltipFormat();
        Object[] messageArguments = this.getMessageArguments(node);
        String message = formatter.format(messageArguments);
        Controller.getCurrentController().getViewController().addStatusInfo(HOOK_NAME, message);
    }

    private void hideStatusInfo() {
        Controller.getCurrentController().getViewController().addStatusInfo(HOOK_NAME, "");
    }
}

