/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.view.swing.map.MapView;

class MapViewChangeObserverCompound {
    private final HashSet<IMapSelectionListener> mapListeners = new LinkedHashSet<IMapSelectionListener>();
    private final HashSet<IMapViewChangeListener> viewListeners = new LinkedHashSet<IMapViewChangeListener>();

    MapViewChangeObserverCompound() {
    }

    void addListener(IMapSelectionListener listener) {
        this.mapListeners.add(listener);
    }

    void addListener(IMapViewChangeListener listener) {
        this.viewListeners.add(listener);
    }

    void afterMapViewChange(MapView oldMap, MapView newMap) {
        MapModel oldModel = this.getMap(oldMap);
        MapModel newModel = this.getMap(newMap);
        this.afterMapChange(oldModel, newModel);
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewChange(oldMap, newMap);
        }
    }

    void afterMapChange(MapModel oldModel, MapModel newModel) {
        if (oldModel != newModel || newModel == null) {
            for (IMapSelectionListener observer : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                observer.afterMapChange(oldModel, newModel);
            }
        }
    }

    void afterMapViewClose(MapView pOldMap) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewClose(pOldMap);
        }
    }

    void beforeMapViewChange(MapView oldMap, MapView newMap) {
        MapModel oldModel = this.getMap(oldMap);
        MapModel newModel = this.getMap(newMap);
        this.beforeMapChange(oldModel, newModel);
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.beforeViewChange(oldMap, newMap);
        }
    }

    void beforeMapChange(MapModel oldModel, MapModel newModel) {
        if (oldModel != newModel) {
            for (IMapSelectionListener observer : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                observer.beforeMapChange(oldModel, newModel);
            }
        }
    }

    private MapModel getMap(MapView view) {
        return view == null ? null : view.getMap();
    }

    void mapViewCreated(MapView previousMapView, MapView createdMapView) {
        this.fireMapViewCreated(createdMapView);
        if (!createdMapView.isShowing()) {
            this.fireMapViewCreatedAfterItIsDisplayed(previousMapView, createdMapView);
        } else if (!createdMapView.isLayoutCompleted()) {
            this.fireMapViewDisplayedLater(previousMapView, createdMapView);
        } else {
            this.fireMapViewDisplayed(previousMapView, createdMapView);
        }
    }

    private void fireMapViewDisplayedLater(final MapView previousView, final MapView createdMapView) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapViewChangeObserverCompound.this.mapViewCreated(previousView, createdMapView);
            }
        });
    }

    private void fireMapViewCreatedAfterItIsDisplayed(final MapView previousView, final MapView createdMapView) {
        HierarchyListener retryEventListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (createdMapView.isShowing()) {
                    createdMapView.removeHierarchyListener(this);
                    MapViewChangeObserverCompound.this.mapViewCreated(previousView, createdMapView);
                }
            }
        };
        createdMapView.addHierarchyListener(retryEventListener);
    }

    private void fireMapViewCreated(MapView createdMapView) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewCreated(createdMapView);
        }
    }

    private void fireMapViewDisplayed(MapView previousMapView, MapView createdMapView) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewDisplayed(previousMapView, createdMapView);
        }
    }

    void removeListener(IMapSelectionListener listener) {
        this.mapListeners.remove(listener);
    }

    void removeListener(IMapViewChangeListener listener) {
        this.viewListeners.remove(listener);
    }
}

