/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.freeplane.view.swing.map.attribute.AttributeTable;

class AttributeViewScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;

    AttributeViewScrollPane(AttributeTable attributeTable) {
        super(attributeTable);
        this.setAlignmentX(0.5f);
        this.setOpaque(false);
        this.getViewport().setOpaque(false);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        this.validate();
        return super.getPreferredSize();
    }

    @Override
    public boolean isVisible() {
        Component view = this.getViewport().getView();
        return super.isVisible() && view != null && view.isVisible();
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new BugFixScrollBar(0);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new BugFixScrollBar(1);
    }

    private static class BugFixScrollBar
    extends JScrollBar {
        private static final long serialVersionUID = -688620479795225879L;

        public BugFixScrollBar(int orientation) {
            super(orientation);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.needsFixForWindowsUI()) {
                g.setColor(this.getForeground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(this.getBackground());
                g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            } else {
                super.paintComponent(g);
            }
        }

        private boolean needsFixForWindowsUI() {
            return this.isPaintingForPrint() && this.getUI().getClass().getSimpleName().equals("WindowsScrollBarUI");
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (!this.needsFixForWindowsUI()) {
                super.paintChildren(g);
            }
        }
    }
}

