/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.dependencies;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.PackageMatcher;
import java.util.Objects;
import java.util.Optional;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyDirection;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class DependencyRule {
    private final DependencyVerdict verdict;
    private final PackageMatcher originMatcher;
    private final PackageMatcher targetMatcher;
    private final DependencyDirection dependencyDirection;
    private final String targetPattern;
    private final String originPattern;

    public DependencyRule(DependencyVerdict type, String originPattern, String targetPattern, DependencyDirection dependencyDirection) {
        this.verdict = type;
        this.originPattern = originPattern;
        this.targetPattern = targetPattern;
        this.originMatcher = PackageMatcher.of((String)originPattern);
        this.targetMatcher = PackageMatcher.of((String)targetPattern);
        this.dependencyDirection = dependencyDirection;
    }

    public Optional<DependencyVerdict> match(Dependency dependency, boolean goesUp) {
        return this.originMatcher.matches(CodeNode.findEnclosingNamedClass(dependency.getOriginClass()).getName().replace('$', '.')) && this.targetMatcher.matches(CodeNode.findEnclosingNamedClass(dependency.getTargetClass()).getName().replace('$', '.')) && this.dependencyDirection.matches(goesUp) ? Optional.of(this.verdict) : Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependencyDirection, this.originPattern, this.targetPattern, this.verdict});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyRule other = (DependencyRule)obj;
        return this.dependencyDirection == other.dependencyDirection && Objects.equals(this.originPattern, other.originPattern) && Objects.equals(this.targetPattern, other.targetPattern) && this.verdict == other.verdict;
    }
}

