/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.List;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public interface HasParameterTypes {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getParameterTypes();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getRawParameterTypes();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(Class<?> ... types) {
            return Predicates.rawParameterTypes(Formatters.formatNamesOf(types));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(String ... types) {
            return Predicates.rawParameterTypes(ImmutableList.copyOf(types));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(List<String> typeNames) {
            return new RawParameterTypesPredicate(DescribedPredicate.equalTo(typeNames).onResultOf(HasName.Functions.GET_NAMES).as("[%s]", Formatters.formatMethodParameterTypeNames(typeNames)));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasParameterTypes> rawParameterTypes(DescribedPredicate<? super List<JavaClass>> predicate) {
            return new RawParameterTypesPredicate(predicate);
        }

        private static class RawParameterTypesPredicate
        extends DescribedPredicate<HasParameterTypes> {
            private final DescribedPredicate<? super List<JavaClass>> predicate;

            RawParameterTypesPredicate(DescribedPredicate<? super List<JavaClass>> predicate) {
                super("raw parameter types " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean test(HasParameterTypes input) {
                return this.predicate.test(input.getRawParameterTypes());
            }
        }
    }
}

