/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules.syntax;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.PackageMatchers;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class ModuleDependencyScope
implements HasDescription {
    private final String description;
    private final Function<Collection<ArchModule<?>>, Predicate<Dependency>> createPredicate;

    private ModuleDependencyScope(String description, Function<Collection<ArchModule<?>>, Predicate<Dependency>> createPredicate) {
        this.description = Preconditions.checkNotNull(description);
        this.createPredicate = Preconditions.checkNotNull(createPredicate);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    Predicate<Dependency> asPredicate(Collection<? extends ArchModule<?>> modules) {
        return this.createPredicate.apply(modules);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static ModuleDependencyScope consideringAllDependencies() {
        return new ModuleDependencyScope("considering all dependencies", __ -> ___ -> true);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static ModuleDependencyScope consideringOnlyDependenciesBetweenModules() {
        return new ModuleDependencyScope("considering only dependencies between modules", modules -> dependency -> modules.stream().anyMatch(it -> it.contains(dependency.getTargetClass())));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static ModuleDependencyScope consideringOnlyDependenciesInAnyPackage(String packageIdentifier, String ... furtherPackageIdentifiers) {
        List<String> packageIdentifiers = Stream.concat(Stream.of(packageIdentifier), Arrays.stream(furtherPackageIdentifiers)).collect(Collectors.toList());
        PackageMatchers packageMatchers = PackageMatchers.of(packageIdentifiers);
        String description = String.format("considering only dependencies in any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers));
        return new ModuleDependencyScope(description, __ -> dependency -> packageMatchers.test(dependency.getTargetClass().getPackageName()));
    }
}

