/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.Util;

class PropertiesDictionary
extends Dictionary<String, Object> {
    private final int ocIndex = 0;
    private final int sidIndex = 1;
    private final int sbidIndex = 2;
    private final int ssIndex = 3;
    private static long nextServiceID = 1L;
    private final String[] keys;
    private final Object[] values;
    private int size = 4;

    PropertiesDictionary(Dictionary in, String[] classes, Long sid, Long bid, String scope) {
        Long l;
        int max_size = (in != null ? in.size() : 0) + this.size;
        this.keys = new String[max_size];
        this.values = new Object[max_size];
        this.keys[0] = "objectClass";
        this.values[0] = classes;
        this.keys[1] = "service.id";
        if (sid != null) {
            l = sid;
        } else {
            long l2 = nextServiceID++;
            l = new Long(l2);
        }
        this.values[1] = l;
        this.keys[2] = "service.bundleid";
        this.values[2] = bid;
        this.keys[3] = "service.scope";
        this.values[3] = scope;
        if (in != null) {
            try {
                Enumeration e = in.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.equalsIgnoreCase("objectClass") || key.equalsIgnoreCase("service.id") || key.equalsIgnoreCase("service.bundleid") || key.equalsIgnoreCase("service.scope")) continue;
                    for (int i = this.size - 1; i >= 0; --i) {
                        if (!key.equalsIgnoreCase(this.keys[i])) continue;
                        throw new IllegalArgumentException("Several entries for property: " + key);
                    }
                    this.keys[this.size] = key;
                    this.values[this.size++] = in.get(key);
                }
            }
            catch (ClassCastException ignore) {
                throw new IllegalArgumentException("Properties contains key that is not of type java.lang.String");
            }
        }
    }

    @Override
    public Object get(Object key) {
        if (key == "objectClass") {
            return this.values[0];
        }
        if (key == "service.id") {
            return this.values[1];
        }
        if (key == "service.bundleid") {
            return this.values[2];
        }
        if (key == "service.scope") {
            return this.values[3];
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!((String)key).equalsIgnoreCase(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public String[] keyArray() {
        String[] nkeys = new String[this.size];
        System.arraycopy(this.keys, 0, nkeys, 0, this.size);
        return nkeys;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Enumeration<Object> elements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Enumeration<String> keys() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object put(String k, Object v) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Object remove(Object k) {
        throw new UnsupportedOperationException("Not implemented");
    }

    Map<String, Object> getDTO() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (int i = 0; i < this.size; ++i) {
            res.put(this.keys[i], Util.safeDTOObject(this.values[i]));
        }
        return res;
    }
}

