/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Arrays;
import org.freeplane.api.BookmarkType;
import org.freeplane.api.Node;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.NodeProxy;

class NodeBookmarkProxy
implements org.freeplane.api.NodeBookmark {
    private final NodeBookmark coreBookmark;
    private final ScriptContext scriptContext;

    public NodeBookmarkProxy(NodeBookmark coreBookmark, ScriptContext scriptContext) {
        this.coreBookmark = coreBookmark;
        this.scriptContext = scriptContext;
    }

    public Node getNode() {
        return new NodeProxy(this.coreBookmark.getNode(), this.scriptContext);
    }

    public String getName() {
        return this.coreBookmark.getDescriptor().getName();
    }

    public BookmarkType getType() {
        return this.coreBookmark.getDescriptor().opensAsRoot() ? BookmarkType.ROOT : BookmarkType.SELECT;
    }

    public void open() {
        this.coreBookmark.open();
    }

    public void open(BookmarkType mode) {
        boolean openAsRoot = mode == BookmarkType.ROOT;
        this.coreBookmark.open(openAsRoot);
    }

    public void open(String mode) {
        try {
            BookmarkType enumMode = BookmarkType.valueOf((String)mode.toUpperCase());
            this.open(enumMode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid bookmark mode: '" + mode + "'. Valid values are: " + Arrays.toString(BookmarkType.values()) + " (case insensitive)", e);
        }
    }
}

