/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Date;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;

public class ReminderProxy
extends AbstractProxy<NodeModel>
implements Proxy.Reminder {
    ReminderProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    public Date getRemindAt() {
        ReminderExtension extension = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (extension == null) {
            return null;
        }
        return new Date(extension.getRemindUserAt());
    }

    public String getPeriodUnit() {
        ReminderExtension extension = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (extension == null || extension.getPeriodUnit() == null) {
            return null;
        }
        return extension.getPeriodUnitAsString();
    }

    public Integer getPeriod() {
        ReminderExtension extension = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (extension == null) {
            return null;
        }
        return extension.getPeriod();
    }

    public String getScript() {
        ReminderExtension extension = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (extension == null) {
            return null;
        }
        return extension.getScript();
    }

    public void createOrReplace(Date remindAt, String periodUnit, Integer period) {
        ReminderHook reminderHook = (ReminderHook)Controller.getCurrentModeController().getExtension(ReminderHook.class);
        reminderHook.undoableDeactivateHook((NodeModel)this.getDelegate());
        ReminderExtension reminder = this.newReminder(remindAt);
        reminder.setPeriodUnitAsString(periodUnit);
        reminder.setPeriod(period.intValue());
        reminderHook.undoableActivateHook((NodeModel)this.getDelegate(), (IExtension)reminder);
    }

    private ReminderExtension newReminder(Date remindAt) {
        ReminderHook reminderHook = (ReminderHook)Controller.getCurrentModeController().getExtension(ReminderHook.class);
        ReminderExtension reminder = new ReminderExtension(reminderHook, (NodeModel)this.getDelegate());
        reminder.setRemindUserAt(remindAt.getTime());
        return reminder;
    }

    public void setScript(String scriptSource) {
        ReminderExtension reminder = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (reminder == null) {
            throw new NullPointerException("no reminder defined for node " + this);
        }
        reminder.setScript(scriptSource);
    }

    public void remove() {
        ReminderHook reminderHook = (ReminderHook)Controller.getCurrentModeController().getExtension(ReminderHook.class);
        reminderHook.undoableDeactivateHook((NodeModel)this.getDelegate());
    }

    public boolean asBoolean() {
        return ((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class) != null;
    }

    @Override
    public String toString() {
        ReminderExtension reminder = (ReminderExtension)((NodeModel)this.getDelegate()).getExtension(ReminderExtension.class);
        if (reminder == null) {
            return "no reminder";
        }
        return "periodic reminder fires at " + reminder.getRemindUserAt() + " and then every " + reminder.getPeriod() + " " + reminder.getPeriodUnit();
    }
}

