/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.api.NodeRO;
import org.freeplane.api.Script;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptRunner;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.proxy.NodeProxy;

abstract class ScriptProxy
implements Script {
    private final Map<String, Boolean> permissions;
    private final ScriptContext scriptContext;
    private PrintStream outStream;

    public ScriptProxy(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        this.permissions = new HashMap<String, Boolean>();
        this.permissions.put("execute_scripts_without_asking", true);
    }

    public ScriptProxy startingApplications() {
        this.permissions.put("execute_scripts_without_exec_restriction", true);
        return this;
    }

    public ScriptProxy accessingNetwork() {
        this.permissions.put("execute_scripts_without_network_restriction", true);
        return this;
    }

    public ScriptProxy readingFiles() {
        this.permissions.put("execute_scripts_without_file_restriction", true);
        return this;
    }

    public ScriptProxy writingFiles() {
        this.permissions.put("execute_scripts_without_write_restriction", true);
        return this;
    }

    public ScriptProxy withAllPermissions() {
        this.permissions.put("execute_scripts_without_file_restriction", true);
        this.permissions.put("execute_scripts_without_write_restriction", true);
        this.permissions.put("execute_scripts_without_network_restriction", true);
        this.permissions.put("execute_scripts_without_exec_restriction", true);
        return this;
    }

    public ScriptProxy withOutput(PrintStream outStream) {
        this.outStream = outStream;
        return this;
    }

    public Object executeOn(NodeRO node) {
        IScript script = this.createScript(new ScriptingPermissions(this.permissions));
        ScriptRunner scriptRunner = new ScriptRunner(script);
        scriptRunner.setScriptContext(this.scriptContext);
        if (this.outStream != null) {
            scriptRunner.setOutStream(this.outStream);
        }
        NodeModel nodeModel = (NodeModel)((NodeProxy)node).getDelegate();
        Object result = scriptRunner.execute(nodeModel);
        return result;
    }

    protected abstract IScript createScript(ScriptingPermissions var1);
}

