/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleController;

@SelectableAction(checkOnNodeChange=true)
class CloudShapeAction
extends AMultipleNodeAction {
    private static final long serialVersionUID = 1L;
    private final CloudShape actionShape;

    public CloudShapeAction(CloudShape actionShape) {
        super("CloudShapeAction." + actionShape.toString());
        this.actionShape = actionShape;
    }

    public void actionPerformed(ActionEvent e) {
        ModeController controller = Controller.getCurrentModeController();
        NodeModel selected = controller.getMapController().getSelectedNode();
        MCloudController cloudController = (MCloudController)CloudController.getController();
        cloudController.setCloud(selected, true);
        super.actionPerformed(e);
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        MCloudController cloudController = (MCloudController)CloudController.getController();
        if (!this.isSelected()) {
            cloudController.setShape(node, this.actionShape);
        } else {
            cloudController.setCloud(node, false);
        }
    }

    public void setSelected() {
        MCloudController cloudController;
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        CloudModel model = CloudModel.getModel((NodeModel)node);
        if (model != null && this.actionShape.equals((Object)(cloudController = (MCloudController)CloudController.getController()).getShape(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE))) {
            this.setSelected(true);
            return;
        }
        this.setSelected(false);
    }
}

