/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.ImageCreator;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class ExportToImage
implements IExportEngine {
    private final String imageDescripton;
    private final String imageType;
    private final int bitmapType;

    public static ExportToImage toPNG() {
        return new ExportToImage("png", "to png", 2);
    }

    ExportToImage(String imageType, String imageDescripton, int bitmapType) {
        this.imageType = imageType;
        this.imageDescripton = imageDescripton;
        this.bitmapType = bitmapType;
    }

    @Override
    public void export(List<NodeModel> nodes, File toFile) {
        this.export(nodes.get(0).getMap(), toFile);
    }

    public void export(MapModel map, File toFile) {
        this.export(map, null, null, null, toFile);
    }

    public void export(MapModel map, Dimension slideSize, NodeModel placedNode, IMapSelection.NodePosition placedNodePosition, File toFile) {
        RenderedImage image = null;
        try {
            RenderedImage renderedImage = image = placedNode != null ? new ImageCreator(this.getImageResolutionDPI()).createBufferedImage(map, slideSize, placedNode, placedNodePosition, this.bitmapType) : new ImageCreator(this.getImageResolutionDPI()).createBufferedImage(map, this.bitmapType);
            if (image != null) {
                this.exportToImage(image, toFile);
            }
        }
        catch (OutOfMemoryError ex) {
            UITools.errorMessage((Object)TextUtils.getText((String)"out_of_memory"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exportToImage(RenderedImage image, File chosenFile) {
        try {
            ImageWriteParam writeParam;
            ImageTypeSpecifier typeSpecifier;
            ImageWriter writer;
            IIOMetadata metadata;
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            Iterator<ImageWriter> imageWritersByFormatName = ImageIO.getImageWritersByFormatName(this.imageType);
            do {
                writer = imageWritersByFormatName.next();
                writeParam = writer.getDefaultWriteParam();
            } while (((metadata = writer.getDefaultImageMetadata(typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(this.bitmapType), writeParam)).isReadOnly() || !metadata.isStandardMetadataFormatSupported()) && imageWritersByFormatName.hasNext());
            this.addDpiToMetadata(metadata);
            try (FileOutputStream outFile = new FileOutputStream(chosenFile);){
                try (ImageOutputStream stream = ImageIO.createImageOutputStream(outFile);){
                    writer.setOutput(ImageIO.createImageOutputStream(outFile));
                    writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                    if (stream == null) return true;
                }
                return true;
            }
        }
        catch (IOException e1) {
            LogUtils.warn((Throwable)e1);
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
            return true;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void addDpiToMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        int dpi = this.getImageResolutionDPI();
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / 2.54;
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    public FileFilter getFileFilter() {
        return new CaseSensitiveFileNameExtensionFilter(this.imageType, this.imageDescripton);
    }

    private int getImageResolutionDPI() {
        return ResourceController.getResourceController().getIntProperty("exported_image_resolution_dpi", 300);
    }
}

