/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NumberProperty;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroupChangeListener;
import org.freeplane.features.mode.Controller;

public class ConnectorWidthControlGroup
implements ControlGroup {
    private BooleanProperty mSetWidth;
    private NumberProperty mWidth;
    private ConnectorWidthChangeListener propertyChangeListener;
    private ConnectorModel connector;

    @Override
    public void updateValue(ConnectorModel connector) {
        this.connector = connector;
        this.propertyChangeListener.update();
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetWidth = new BooleanProperty("set_property_text");
        this.mWidth = new NumberProperty("edit_width_label", 1, 255, 1);
        this.mWidth.setNameAsLabelAndToolTip();
        this.propertyChangeListener = new ConnectorWidthChangeListener(this.mSetWidth, (IPropertyControl)this.mWidth);
        this.mSetWidth.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mWidth.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mSetWidth.appendToForm(formBuilder);
        this.mWidth.appendToForm(formBuilder);
    }

    private class ConnectorWidthChangeListener
    extends ControlGroupChangeListener {
        public ConnectorWidthChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, PropertyChangeEvent evt) {
            MLinkController linkController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            try {
                linkController.setWidth(ConnectorWidthControlGroup.this.connector, enabled ? Optional.of(Integer.valueOf(ConnectorWidthControlGroup.this.mWidth.getValue())) : Optional.empty());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        void updateValue() {
            LinkController linkController = LinkController.getController();
            Optional opacity = ConnectorWidthControlGroup.this.connector.getAlpha();
            Integer viewWidth = linkController.getWidth(ConnectorWidthControlGroup.this.connector);
            ConnectorWidthControlGroup.this.mSetWidth.setValue(opacity.isPresent());
            ConnectorWidthControlGroup.this.mWidth.setValue(viewWidth.toString());
        }
    }
}

