/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.CollectionBoxController;
import org.freeplane.features.presentations.mindmapmode.CollectionChangeListener;
import org.freeplane.features.presentations.mindmapmode.CollectionChangedEvent;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.NavigationPanelController;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.features.presentations.mindmapmode.SlideEditorController;

public class PresentationEditorController {
    private final CollectionBoxController<Presentation> presentationPanelController = new CollectionBoxController("presentation");
    private final CollectionBoxController<Slide> slidePanelController = new CollectionBoxController("slide");
    private final SlideEditorController slideEditorController;
    private final NavigationPanelController navigationPanelController;
    private NamedElementCollection<Presentation> presentations;
    private CollectionChangeListener<Presentation> presentationChangeListener;

    public PresentationEditorController(final PresentationState presentationState) {
        this.slideEditorController = new SlideEditorController(presentationState);
        presentationState.addPresentationStateListener(new PresentationStateChangeListener(){

            @Override
            public void onPresentationStateChange(PresentationStateChangeEvent presentationStateChangeEvent) {
                if (presentationStateChangeEvent.eventType == PresentationStateChangeEvent.EventType.PLAYING_STATE_CHANGED) {
                    if (presentationStateChangeEvent.presentationState.isPresentationRunning()) {
                        PresentationEditorController.this.presentationPanelController.disableEditing();
                        PresentationEditorController.this.slidePanelController.disableEditing();
                    } else {
                        PresentationEditorController.this.presentationPanelController.enableEditing();
                        PresentationEditorController.this.slidePanelController.enableEditing();
                    }
                }
            }
        });
        this.navigationPanelController = new NavigationPanelController(presentationState);
        final CollectionChangeListener<Slide> slideChangeListener = new CollectionChangeListener<Slide>(){
            private Slide slide;

            @Override
            public void onCollectionChange(CollectionChangedEvent<Slide> event) {
                this.slide = (Slide)event.collection.getCurrentElement();
                PresentationEditorController.this.slideEditorController.setSlide(this.slide);
            }
        };
        this.presentationChangeListener = new CollectionChangeListener<Presentation>(){
            private NamedElementCollection<Slide> slides;

            @Override
            public void onCollectionChange(CollectionChangedEvent<Presentation> event) {
                Presentation presentation;
                if (this.slides != null) {
                    this.slides.removeCollectionChangeListener(slideChangeListener);
                }
                Presentation presentation2 = presentation = event.collection != null ? (Presentation)event.collection.getCurrentElement() : null;
                if (presentation != null) {
                    this.slides = presentation.slides;
                    this.slides.addCollectionChangeListener(slideChangeListener);
                    PresentationEditorController.this.slideEditorController.setSlide(this.slides.getCurrentElement());
                } else {
                    this.slides = null;
                    PresentationEditorController.this.slideEditorController.setSlide(null);
                }
                presentationState.changePresentation(event);
                PresentationEditorController.this.slidePanelController.setCollection(this.slides);
                PresentationEditorController.this.navigationPanelController.setPresentation(presentation);
            }
        };
    }

    public void setPresentations(NamedElementCollection<Presentation> newPresentations) {
        if (this.presentations != null) {
            this.presentations.removeCollectionChangeListener(this.presentationChangeListener);
        }
        this.presentations = newPresentations;
        this.presentationPanelController.setCollection(this.presentations);
        if (this.presentations != null) {
            Presentation presentation = this.presentations.getCurrentElement();
            if (presentation != null) {
                this.slidePanelController.setCollection(presentation.slides);
                this.slideEditorController.setSlide(presentation.slides.getCurrentElement());
            }
            this.presentations.addCollectionChangeListener(this.presentationChangeListener);
        }
        this.presentationChangeListener.onCollectionChange(CollectionChangedEvent.EventType.SELECTION_CHANGED.of(this.presentations));
    }

    Component createPanel(ModeController modeController) {
        Box panel = Box.createVerticalBox();
        JComponent presentationBox = this.presentationPanelController.createCollectionBox();
        TranslatedElementFactory.createTitledBorder((JComponent)presentationBox, (String)"slide.presentations");
        panel.add(presentationBox);
        JComponent slideBox = this.slidePanelController.createCollectionBox();
        TranslatedElementFactory.createTitledBorder((JComponent)slideBox, (String)"slide.slides");
        panel.add(slideBox);
        Box content = this.slideEditorController.createSlideContentBox();
        panel.add(content);
        JComponent navigation = this.navigationPanelController.createNavigationBox();
        panel.add(navigation);
        if (modeController != null) {
            JComponent controlBox = this.createActionPanel(modeController);
            panel.add(controlBox);
        }
        return panel;
    }

    private JComponent createActionPanel(ModeController modeController) {
        AFreeplaneAction exportPresentationAction = modeController.getAction("ExportPresentationAction");
        AFreeplaneAction exportAllPresentationsAction = modeController.getAction("ExportAllPresentationsAction");
        JPanel controlButtons = new JPanel(new GridLayout(3, 1));
        JButton btnExportPresentation = new JButton((Action)exportPresentationAction);
        btnExportPresentation.setAlignmentX(0.5f);
        controlButtons.add(btnExportPresentation);
        JButton btnExportAllPresentations = new JButton((Action)exportAllPresentationsAction);
        btnExportAllPresentations.setAlignmentX(0.5f);
        controlButtons.add(btnExportAllPresentations);
        AFreeplaneAction configureAction = modeController.getAction("ShowPreferencesAction");
        JButton btnConfigure = new JButton((Action)configureAction);
        btnConfigure.setActionCommand("OptionPanel.Presentation");
        btnConfigure.setAlignmentX(0.5f);
        controlButtons.add(btnConfigure);
        Dimension maximumSize = new Dimension(controlButtons.getPreferredSize());
        maximumSize.width = Integer.MAX_VALUE;
        controlButtons.setMaximumSize(maximumSize);
        return controlButtons;
    }

    void registerActions(ModeController modeController) {
        this.navigationPanelController.registerActions(modeController);
    }
}

