/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportToImage;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationController;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.features.url.UrlManager;

class PresentationPngExporter {
    private final File exportDirectory;
    private final PresentationState presentationState;
    private final float zoom;
    private final NodeModel[] selection;
    private boolean presentationSlowMotionEnabled;
    private boolean spotlightEnabledForExport;
    private final JComponent mapViewComponent;
    private float presentationZoomFactor;

    static void exportPresentation(PresentationState presentationState) {
        PresentationPngExporterFactory presentationPngExporterFactory = new PresentationPngExporterFactory(presentationState);
        PresentationPngExporter exporter = presentationPngExporterFactory.exporter;
        if (exporter != null) {
            exporter.exportSinglePresentation();
        }
    }

    static void exportPresentations(PresentationState presentationState) {
        PresentationPngExporterFactory presentationPngExporterFactory = new PresentationPngExporterFactory(presentationState);
        PresentationPngExporter exporter = presentationPngExporterFactory.exporter;
        if (exporter != null) {
            exporter.exportAllPresentations();
        }
    }

    private PresentationPngExporter(PresentationState presentationState, File exportDirectory) {
        this.presentationState = presentationState;
        this.exportDirectory = exportDirectory;
        this.zoom = Controller.getCurrentController().getMapViewManager().getZoom();
        List selection = Controller.getCurrentController().getSelection().getOrderedSelection();
        this.selection = selection.toArray(new NodeModel[selection.size()]);
        this.mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
    }

    private void exportAllPresentations() {
        this.prepareExport();
        NamedElementCollection<Presentation> presentations = this.presentationState.getPresentations();
        for (int i = 0; i < presentations.getSize(); ++i) {
            this.exportPresentation(presentations.getElement(i));
        }
        this.restorePreviousPresentation();
        UrlManager.getController().loadHyperlink(new Hyperlink(this.exportDirectory.toURI()));
    }

    private void prepareExport() {
        this.presentationSlowMotionEnabled = ResourceController.getResourceController().getBooleanProperty("presentation.slowMotion", false);
        this.presentationZoomFactor = this.presentationState.isPresentationRunning() ? this.presentationState.getPresentationZoomFactor() : (this.presentationState.usesMapZoom() ? Controller.getCurrentController().getMapViewManager().getZoom() : 1.0f);
        ResourceController.getResourceController().setProperty("presentation.slowMotion", false);
        if (ResourceController.getResourceController().getBooleanProperty("presentation.switchToSpotlight") && !Boolean.TRUE.equals(this.mapViewComponent.getClientProperty("spotlight"))) {
            this.mapViewComponent.putClientProperty("spotlight", true);
            this.spotlightEnabledForExport = true;
        }
    }

    private void exportSinglePresentation() {
        this.prepareExport();
        NamedElementCollection<Presentation> presentations = this.presentationState.getPresentations();
        this.exportPresentation(presentations.getCurrentElement());
        this.restorePreviousPresentation();
        UrlManager.getController().loadHyperlink(new Hyperlink(this.exportDirectory.toURI()));
    }

    private void restorePreviousPresentation() {
        this.presentationState.restore();
        this.presentationZoomFactor = 1.0f;
        IMapSelection selectionController = Controller.getCurrentController().getSelection();
        selectionController.replaceSelection(this.selection);
        if (!this.presentationState.isPresentationRunning()) {
            Controller.getCurrentController().getMapViewManager().setZoom(this.zoom);
        }
        ResourceController.getResourceController().setProperty("presentation.slowMotion", this.presentationSlowMotionEnabled);
        if (this.spotlightEnabledForExport) {
            this.mapViewComponent.putClientProperty("spotlight", null);
        }
        selectionController.scrollNodeToVisible(selectionController.getSelected());
    }

    public void exportPresentation(Presentation p) {
        String validName = FileUtils.validFileNameOf((String)p.getName());
        if (validName.isEmpty()) {
            return;
        }
        this.exportDirectory.mkdir();
        if (!this.exportDirectory.isDirectory()) {
            return;
        }
        File presentationDirectory = new File(this.exportDirectory, validName);
        presentationDirectory.mkdir();
        if (!this.exportDirectory.isDirectory()) {
            return;
        }
        NamedElementCollection<Slide> slides = p.slides;
        for (int i = 0; i < slides.getSize(); ++i) {
            this.exportSlide(presentationDirectory, slides.getElement(i));
        }
    }

    private void exportSlide(File presentationDirectory, Slide slide) {
        NodeModel placedNode = slide.getCurrentPlacedNode();
        if (placedNode != null) {
            slide.apply(this.presentationZoomFactor);
        } else {
            slide.apply(1.0f);
        }
        this.mapViewComponent.validate();
        this.mapViewComponent.setSize(this.mapViewComponent.getPreferredSize());
        File exportFile = new File(presentationDirectory, FileUtils.validFileNameOf((String)slide.getName()) + ".png");
        ExportToImage exporter = ExportToImage.toPNG();
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        if (placedNode != null) {
            Dimension slideSize = ResourceController.getResourceController().getBooleanProperty("presentation.switchToFullScreen") ? this.mapViewComponent.getGraphicsConfiguration().getBounds().getSize() : SwingUtilities.getWindowAncestor(this.mapViewComponent).getSize();
            exporter.export(map, slideSize, slide.getCurrentPlacedNode(), slide.getPlacedNodePosition(), exportFile);
        } else {
            exporter.export(map, exportFile);
        }
    }

    private static class PresentationPngExporterFactory {
        private NamedElementCollection<Presentation> presentations;
        private PresentationPngExporter exporter;

        public PresentationPngExporterFactory(PresentationState presentationState) {
            PresentationController presentationController = (PresentationController)Controller.getCurrentModeController().getExtension(PresentationController.class);
            MapModel map = Controller.getCurrentController().getMap();
            if (map == null) {
                return;
            }
            this.presentations = presentationController.getPresentations((MapModel)map).presentations;
            if (this.presentations.getSize() == 0) {
                return;
            }
            File file = map.getFile();
            String name = ResourceController.getResourceController().getProperty("presentation.exportDirectory");
            String validName = FileUtils.validFileNameOf((String)name);
            File presentationExportDirectory = new File(validName.isEmpty() ? "exportDirectory" : validName);
            if (file == null && !presentationExportDirectory.isAbsolute()) {
                JOptionPane.showMessageDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent(), TextUtils.getText((String)"map_not_saved"), "Freeplane", 2);
                return;
            }
            File exportDirectory = presentationExportDirectory.isAbsolute() ? presentationExportDirectory : new File(file.getAbsoluteFile().getParentFile(), presentationExportDirectory.getPath());
            this.exporter = new PresentationPngExporter(presentationState, exportDirectory);
        }
    }

    private static class ExportPresentationAction
    extends AFreeplaneAction {
        private final PresentationState state;

        public ExportPresentationAction(PresentationState state) {
            super("ExportPresentationAction");
            this.state = state;
        }

        public void actionPerformed(ActionEvent e) {
            PresentationPngExporter.exportPresentation(this.state);
        }
    }

    private static class ExportAllPresentationsAction
    extends AFreeplaneAction {
        private final PresentationState state;

        public ExportAllPresentationsAction(PresentationState state) {
            super("ExportAllPresentationsAction");
            this.state = state;
        }

        public void actionPerformed(ActionEvent e) {
            PresentationPngExporter.exportPresentations(this.state);
        }
    }

    static class ActionInstaller {
        ActionInstaller() {
        }

        public void installActions(ModeController modeController, PresentationState state) {
            modeController.addAction((AFreeplaneAction)new ExportAllPresentationsAction(state));
            modeController.addAction((AFreeplaneAction)new ExportPresentationAction(state));
        }
    }
}

