/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.format.PatternFormat;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.mindmapmode.EditablePatternComboProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class FormatControlGroup
implements ControlGroup {
    static final String NODE_FORMAT = "nodeformat";
    private RevertingProperty mSetNodeFormat;
    private EditablePatternComboProperty mNodeFormat;
    private NodeFormatChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFormat = new RevertingProperty();
        this.mNodeFormat = new EditablePatternComboProperty(NODE_FORMAT, PatternFormat.getIdentityPatternFormat(), FormatController.getController().getAllFormats());
        this.propertyChangeListener = new NodeFormatChangeListener(this.mSetNodeFormat, (IPropertyControl)this.mNodeFormat);
        this.mSetNodeFormat.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeFormat.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeFormat.appendToForm(formBuilder);
        this.mSetNodeFormat.appendToForm(formBuilder);
    }

    private class NodeFormatChangeListener
    extends ControlGroupChangeListener {
        public NodeFormatChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            String selectedPattern = FormatControlGroup.this.mNodeFormat.getSelectedPattern();
            styleController.setNodeFormat(node, enabled ? (selectedPattern != null ? selectedPattern : styleController.getNodeFormat(node)) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            String nodeFormat = NodeStyleModel.getNodeFormat((NodeModel)node);
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            String viewNodeFormat = styleController.getNodeFormat(node);
            FormatControlGroup.this.mSetNodeFormat.setValue(nodeFormat != null);
            if (viewNodeFormat == null && node.getUserObject() instanceof IFormattedObject) {
                viewNodeFormat = ((IFormattedObject)node.getUserObject()).getPattern();
            }
            FormatControlGroup.this.mNodeFormat.setValue(viewNodeFormat);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, FormatControlGroup.this.mSetNodeFormat);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)FormatControlGroup.this.mNodeFormat);
        }
    }
}

